/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.model;

import io.dropwizard.revolver.core.model.RevolverApiMetadata;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RevolverServiceMetadata {
    private String name;
    private String type;
    private String status;
    private long instances = -1L;
    private long healthy = -1L;
    private long unhealthy = -1L;
    private List<RevolverApiMetadata> apis;

    public static RevolverServiceMetadataBuilder builder() {
        return new RevolverServiceMetadataBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public long getInstances() {
        return this.instances;
    }

    public long getHealthy() {
        return this.healthy;
    }

    public long getUnhealthy() {
        return this.unhealthy;
    }

    public List<RevolverApiMetadata> getApis() {
        return this.apis;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setInstances(long instances) {
        this.instances = instances;
    }

    public void setHealthy(long healthy) {
        this.healthy = healthy;
    }

    public void setUnhealthy(long unhealthy) {
        this.unhealthy = unhealthy;
    }

    public void setApis(List<RevolverApiMetadata> apis) {
        this.apis = apis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverServiceMetadata)) {
            return false;
        }
        RevolverServiceMetadata other = (RevolverServiceMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        if (this.getInstances() != other.getInstances()) {
            return false;
        }
        if (this.getHealthy() != other.getHealthy()) {
            return false;
        }
        if (this.getUnhealthy() != other.getUnhealthy()) {
            return false;
        }
        List<RevolverApiMetadata> this$apis = this.getApis();
        List<RevolverApiMetadata> other$apis = other.getApis();
        return !(this$apis == null ? other$apis != null : !((Object)this$apis).equals(other$apis));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverServiceMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        long $instances = this.getInstances();
        result = result * 59 + (int)($instances >>> 32 ^ $instances);
        long $healthy = this.getHealthy();
        result = result * 59 + (int)($healthy >>> 32 ^ $healthy);
        long $unhealthy = this.getUnhealthy();
        result = result * 59 + (int)($unhealthy >>> 32 ^ $unhealthy);
        List<RevolverApiMetadata> $apis = this.getApis();
        result = result * 59 + ($apis == null ? 43 : ((Object)$apis).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverServiceMetadata(name=" + this.getName() + ", type=" + this.getType() + ", status=" + this.getStatus() + ", instances=" + this.getInstances() + ", healthy=" + this.getHealthy() + ", unhealthy=" + this.getUnhealthy() + ", apis=" + this.getApis() + ")";
    }

    @ConstructorProperties(value={"name", "type", "status", "instances", "healthy", "unhealthy", "apis"})
    public RevolverServiceMetadata(String name, String type, String status, long instances, long healthy, long unhealthy, List<RevolverApiMetadata> apis) {
        this.name = name;
        this.type = type;
        this.status = status;
        this.instances = instances;
        this.healthy = healthy;
        this.unhealthy = unhealthy;
        this.apis = apis;
    }

    public RevolverServiceMetadata() {
    }

    public static class RevolverServiceMetadataBuilder {
        private String name;
        private String type;
        private String status;
        private long instances;
        private long healthy;
        private long unhealthy;
        private ArrayList<RevolverApiMetadata> apis;

        RevolverServiceMetadataBuilder() {
        }

        public RevolverServiceMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RevolverServiceMetadataBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverServiceMetadataBuilder status(String status) {
            this.status = status;
            return this;
        }

        public RevolverServiceMetadataBuilder instances(long instances) {
            this.instances = instances;
            return this;
        }

        public RevolverServiceMetadataBuilder healthy(long healthy) {
            this.healthy = healthy;
            return this;
        }

        public RevolverServiceMetadataBuilder unhealthy(long unhealthy) {
            this.unhealthy = unhealthy;
            return this;
        }

        public RevolverServiceMetadataBuilder apis(RevolverApiMetadata apis) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.add(apis);
            return this;
        }

        public RevolverServiceMetadataBuilder apis(Collection<? extends RevolverApiMetadata> apis) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.addAll(apis);
            return this;
        }

        public RevolverServiceMetadataBuilder clearApis() {
            if (this.apis != null) {
                this.apis.clear();
            }
            return this;
        }

        public RevolverServiceMetadata build() {
            List<RevolverApiMetadata> apis;
            switch (this.apis == null ? 0 : this.apis.size()) {
                case 0: {
                    apis = Collections.emptyList();
                    break;
                }
                case 1: {
                    apis = Collections.singletonList(this.apis.get(0));
                    break;
                }
                default: {
                    apis = Collections.unmodifiableList(new ArrayList<RevolverApiMetadata>(this.apis));
                }
            }
            return new RevolverServiceMetadata(this.name, this.type, this.status, this.instances, this.healthy, this.unhealthy, apis);
        }

        public String toString() {
            return "RevolverServiceMetadata.RevolverServiceMetadataBuilder(name=" + this.name + ", type=" + this.type + ", status=" + this.status + ", instances=" + this.instances + ", healthy=" + this.healthy + ", unhealthy=" + this.unhealthy + ", apis=" + this.apis + ")";
        }
    }
}

