/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

public class RevolverHttpAuthorizationConfig {
    private String type = "dynamic";
    @NotEmpty
    private Set<String> methods;
    @NotEmpty
    private Set<String> roles;

    public static RevolverHttpAuthorizationConfigBuilder builder() {
        return new RevolverHttpAuthorizationConfigBuilder();
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMethods(Set<String> methods) {
        this.methods = methods;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpAuthorizationConfig)) {
            return false;
        }
        RevolverHttpAuthorizationConfig other = (RevolverHttpAuthorizationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Set<String> this$methods = this.getMethods();
        Set<String> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpAuthorizationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Set<String> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverHttpAuthorizationConfig(type=" + this.getType() + ", methods=" + this.getMethods() + ", roles=" + this.getRoles() + ")";
    }

    @ConstructorProperties(value={"type", "methods", "roles"})
    public RevolverHttpAuthorizationConfig(String type, Set<String> methods, Set<String> roles) {
        this.type = type;
        this.methods = methods;
        this.roles = roles;
    }

    public RevolverHttpAuthorizationConfig() {
    }

    public static class RevolverHttpAuthorizationConfigBuilder {
        private String type;
        private ArrayList<String> methods;
        private ArrayList<String> roles;

        RevolverHttpAuthorizationConfigBuilder() {
        }

        public RevolverHttpAuthorizationConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder method(String method) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder methods(Collection<? extends String> methods) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.addAll(methods);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder role(String role) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.add(role);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder roles(Collection<? extends String> roles) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.addAll(roles);
            return this;
        }

        public RevolverHttpAuthorizationConfig build() {
            Set<String> roles;
            Set<Object> methods;
            switch (this.methods == null ? 0 : this.methods.size()) {
                case 0: {
                    methods = Collections.emptySet();
                    break;
                }
                case 1: {
                    methods = Collections.singleton(this.methods.get(0));
                    break;
                }
                default: {
                    methods = new LinkedHashSet(this.methods.size() < 0x40000000 ? 1 + this.methods.size() + (this.methods.size() - 3) / 3 : Integer.MAX_VALUE);
                    methods.addAll(this.methods);
                    methods = Collections.unmodifiableSet(methods);
                }
            }
            switch (this.roles == null ? 0 : this.roles.size()) {
                case 0: {
                    roles = Collections.emptySet();
                    break;
                }
                case 1: {
                    roles = Collections.singleton(this.roles.get(0));
                    break;
                }
                default: {
                    roles = new LinkedHashSet(this.roles.size() < 0x40000000 ? 1 + this.roles.size() + (this.roles.size() - 3) / 3 : Integer.MAX_VALUE);
                    roles.addAll(this.roles);
                    roles = Collections.unmodifiableSet(roles);
                }
            }
            return new RevolverHttpAuthorizationConfig(this.type, methods, roles);
        }

        public String toString() {
            return "RevolverHttpAuthorizationConfig.RevolverHttpAuthorizationConfigBuilder(type=" + this.type + ", methods=" + this.methods + ", roles=" + this.roles + ")";
        }
    }
}

