/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.revolver.exception.RevolverException;
import javax.inject.Singleton;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json", "application/msgpack", "application/xml"})
@Singleton
public class RevolverExceptionMapper
implements ExceptionMapper<RevolverException> {
    private ObjectMapper objectMapper;

    public RevolverExceptionMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Response toResponse(RevolverException exception) {
        try {
            return Response.status((int)exception.getStatus()).entity((Object)this.objectMapper.writeValueAsBytes((Object)ImmutableMap.builder().put((Object)"errorCode", (Object)exception.getErrorCode()).put((Object)"message", (Object)exception.getMessage()).build())).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)"Server Error".getBytes()).build();
        }
    }
}

