/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import com.google.common.collect.Lists;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.MailBoxConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.discovery.ServiceResolverConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

public class RevolverConfig {
    @NotNull
    @Valid
    private ClientConfig clientConfig;
    @NotNull
    @Valid
    private RuntimeConfig global;
    @NotNull
    @Valid
    private ServiceResolverConfig serviceResolverConfig;
    @NotNull
    @NotBlank
    private String hystrixStreamPath;
    @NotNull
    @NotEmpty
    @Valid
    private List<RevolverServiceConfig> services;
    @NotNull
    @Valid
    private MailBoxConfig mailBox;
    @Max(value=30000L)
    private int callbackTimeout = 3000;

    public RevolverConfig(ClientConfig clientConfig, RuntimeConfig global, ServiceResolverConfig serviceResolverConfig, String hystrixStreamPath, List<RevolverServiceConfig> services, MailBoxConfig mailBox) {
        this.clientConfig = clientConfig;
        this.global = global;
        this.serviceResolverConfig = serviceResolverConfig;
        this.hystrixStreamPath = hystrixStreamPath;
        this.services = services;
        this.mailBox = mailBox;
        this.callbackTimeout = 3000;
    }

    public RevolverConfig() {
        this.global = new RuntimeConfig();
        this.serviceResolverConfig = new ServiceResolverConfig();
        this.hystrixStreamPath = "/hystrix.stream";
        this.services = Lists.newArrayList();
        this.callbackTimeout = 3000;
    }

    public static RevolverConfigBuilder builder() {
        return new RevolverConfigBuilder();
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public RuntimeConfig getGlobal() {
        return this.global;
    }

    public void setGlobal(RuntimeConfig global) {
        this.global = global;
    }

    public ServiceResolverConfig getServiceResolverConfig() {
        return this.serviceResolverConfig;
    }

    public void setServiceResolverConfig(ServiceResolverConfig serviceResolverConfig) {
        this.serviceResolverConfig = serviceResolverConfig;
    }

    public String getHystrixStreamPath() {
        return this.hystrixStreamPath;
    }

    public void setHystrixStreamPath(String hystrixStreamPath) {
        this.hystrixStreamPath = hystrixStreamPath;
    }

    public List<RevolverServiceConfig> getServices() {
        return this.services;
    }

    public void setServices(List<RevolverServiceConfig> services) {
        this.services = services;
    }

    public MailBoxConfig getMailBox() {
        return this.mailBox;
    }

    public void setMailBox(MailBoxConfig mailBox) {
        this.mailBox = mailBox;
    }

    public int getCallbackTimeout() {
        return this.callbackTimeout;
    }

    public void setCallbackTimeout(int callbackTimeout) {
        this.callbackTimeout = callbackTimeout;
    }

    public static class RevolverConfigBuilder {
        private ClientConfig clientConfig;
        private RuntimeConfig global;
        private ServiceResolverConfig serviceResolverConfig;
        private String hystrixStreamPath;
        private ArrayList<RevolverServiceConfig> services;
        private MailBoxConfig mailBox;

        RevolverConfigBuilder() {
        }

        public RevolverConfigBuilder clientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public RevolverConfigBuilder global(RuntimeConfig global) {
            this.global = global;
            return this;
        }

        public RevolverConfigBuilder serviceResolverConfig(ServiceResolverConfig serviceResolverConfig) {
            this.serviceResolverConfig = serviceResolverConfig;
            return this;
        }

        public RevolverConfigBuilder hystrixStreamPath(String hystrixStreamPath) {
            this.hystrixStreamPath = hystrixStreamPath;
            return this;
        }

        public RevolverConfigBuilder service(RevolverServiceConfig service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public RevolverConfigBuilder services(Collection<? extends RevolverServiceConfig> services) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public RevolverConfigBuilder mailBox(MailBoxConfig mailBox) {
            this.mailBox = mailBox;
            return this;
        }

        public RevolverConfig build() {
            List<RevolverServiceConfig> services;
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<RevolverServiceConfig>(this.services));
                }
            }
            return new RevolverConfig(this.clientConfig, this.global, this.serviceResolverConfig, this.hystrixStreamPath, services, this.mailBox);
        }

        public String toString() {
            return "RevolverConfig.RevolverConfigBuilder(clientConfig=" + this.clientConfig + ", global=" + this.global + ", serviceResolverConfig=" + this.serviceResolverConfig + ", hystrixStreamPath=" + this.hystrixStreamPath + ", services=" + this.services + ", mailBox=" + this.mailBox + ")";
        }
    }
}

