/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.model.RevolverApiMetadata;
import io.dropwizard.revolver.core.model.RevolverMetadataResponse;
import io.dropwizard.revolver.core.model.RevolverServiceMetadata;
import io.dropwizard.revolver.discovery.RevolverServiceResolver;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
public class RevolverMetadataResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverMetadataResource.class);
    private RevolverConfig config;

    public RevolverMetadataResource(RevolverConfig config) {
        this.config = config;
    }

    @Path(value="/v1/metadata/status")
    @GET
    @Metered
    @ApiOperation(value="Get the status & metadata of revolver api gateway")
    @Produces(value={"application/json"})
    public RevolverMetadataResponse status() {
        RevolverMetadataResponse.RevolverMetadataResponseBuilder metadataResponse = RevolverMetadataResponse.builder();
        metadataResponse.clientId(this.config.getClientConfig().getClientName());
        List<RevolverHttpServiceConfig> services = this.config.getServices().stream().filter(service -> service instanceof RevolverHttpServiceConfig).map(service -> (RevolverHttpServiceConfig)service).sorted((o1, o2) -> o1.getService().compareTo(o2.getService())).collect(Collectors.toList());
        services.forEach(s -> {
            RevolverServiceMetadata.RevolverServiceMetadataBuilder serviceMetadataBuilder = RevolverServiceMetadata.builder();
            serviceMetadataBuilder.name(s.getService()).type(s.getType()).apis(this.apiMetadataList((RevolverHttpServiceConfig)s));
            if (s.getEndpoint() instanceof RangerEndpointSpec) {
                this.instanceStats(s.getService(), (RangerEndpointSpec)s.getEndpoint(), serviceMetadataBuilder);
            } else {
                serviceMetadataBuilder.status("UNKNOWN");
            }
            metadataResponse.service(serviceMetadataBuilder.build());
        });
        return metadataResponse.build();
    }

    @Path(value="/v1/metadata/config")
    @GET
    @Metered
    @ApiOperation(value="Get configuration of revolver api gateway")
    @Produces(value={"application/json"})
    public RevolverConfig config() {
        return this.config;
    }

    private List<RevolverApiMetadata> apiMetadataList(RevolverHttpServiceConfig httpServiceConfig) {
        return httpServiceConfig.getApis().parallelStream().map(a -> RevolverApiMetadata.builder().async(a.isAsync()).name(a.getApi()).path(a.getPath()).methods(a.getMethods()).build()).sorted((o1, o2) -> o1.getPath().compareTo(o2.getPath())).collect(Collectors.toList());
    }

    private void instanceStats(String service, RangerEndpointSpec endpoint, RevolverServiceMetadata.RevolverServiceMetadataBuilder serviceMetadataBuilder) {
        RevolverServiceResolver serviceResolver = RevolverBundle.getServiceNameResolver();
        if (serviceResolver == null) {
            serviceMetadataBuilder.status("UNKNOWN");
        } else if (serviceResolver.getServiceFinders().containsKey(service)) {
            List serviceNodes = serviceResolver.getServiceFinders().get(service).getShardFinder().getAll((Object)new RevolverServiceResolver.ShardInfo(endpoint.getEnvironment()));
            long healthy = serviceNodes.parallelStream().filter(n -> n.getHealthcheckStatus() == HealthcheckStatus.healthy).count();
            serviceMetadataBuilder.instances(serviceNodes.size()).healthy(healthy).unhealthy((long)serviceNodes.size() - healthy);
            serviceMetadataBuilder.status(healthy > 0L ? "HEALTHY" : "UNHEALTHY");
        } else {
            serviceMetadataBuilder.status("UNKNOWN");
        }
    }

    public static RevolverMetadataResourceBuilder builder() {
        return new RevolverMetadataResourceBuilder();
    }

    public RevolverConfig getConfig() {
        return this.config;
    }

    public void setConfig(RevolverConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverMetadataResource)) {
            return false;
        }
        RevolverMetadataResource other = (RevolverMetadataResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$config = this.getConfig();
        RevolverConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverMetadataResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "RevolverMetadataResource(config=" + this.getConfig() + ")";
    }

    public static class RevolverMetadataResourceBuilder {
        private RevolverConfig config;

        RevolverMetadataResourceBuilder() {
        }

        public RevolverMetadataResourceBuilder config(RevolverConfig config) {
            this.config = config;
            return this;
        }

        public RevolverMetadataResource build() {
            return new RevolverMetadataResource(this.config);
        }

        public String toString() {
            return "RevolverMetadataResource.RevolverMetadataResourceBuilder(config=" + this.config + ")";
        }
    }
}

