/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Strings;
import io.dropwizard.jersey.PATCH;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverAckMessage;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.model.ApiPathMap;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/apis")
@Singleton
@Api(value="Revolver Gateway", description="Revolver api gateway endpoints")
public class RevolverRequestResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverRequestResource.class);
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper msgPackObjectMapper;
    private final XmlMapper xmlObjectMapper;
    private final PersistenceProvider persistenceProvider;

    public RevolverRequestResource(ObjectMapper jsonObjectMapper, ObjectMapper msgPackObjectMapper, XmlMapper xmlObjectMapper, PersistenceProvider persistenceProvider) {
        this.jsonObjectMapper = jsonObjectMapper;
        this.msgPackObjectMapper = msgPackObjectMapper;
        this.xmlObjectMapper = xmlObjectMapper;
        this.persistenceProvider = persistenceProvider;
    }

    @GET
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver GET api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    public Response get(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.GET, path, headers, uriInfo, null);
    }

    @HEAD
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver HEAD api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    public Response head(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.HEAD, path, headers, uriInfo, null);
    }

    @POST
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver POST api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    @Consumes(value={"application/json", "application/msgpack", "application/xml"})
    public Response post(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.POST, path, headers, uriInfo, body);
    }

    @PUT
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver PUT api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    @Consumes(value={"application/json", "application/msgpack", "application/xml"})
    public Response put(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.PUT, path, headers, uriInfo, body);
    }

    @DELETE
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver DELETE api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    public Response delete(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.DELETE, path, headers, uriInfo, null);
    }

    @PATCH
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver PATCH api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    @Consumes(value={"application/json", "application/msgpack", "application/xml"})
    public Response patch(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.PATCH, path, headers, uriInfo, body);
    }

    @OPTIONS
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver OPTIONS api endpoint")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    @Consumes(value={"application/json", "application/msgpack", "application/xml"})
    public Response options(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.OPTIONS, path, headers, uriInfo, body);
    }

    private Response processRequest(String service, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws Exception {
        ApiPathMap apiMap = RevolverBundle.matchPath(service, path);
        if (apiMap == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Collections.singletonMap("message", "Bad Request")).build();
        }
        String callMode = (String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE");
        if (Strings.isNullOrEmpty((String)callMode)) {
            return this.executeInline(service, apiMap.getApi(), method, path, headers, uriInfo, body);
        }
        switch (callMode.toUpperCase()) {
            case "POLLING": {
                return this.executeCommandAsync(service, apiMap.getApi(), method, path, headers, uriInfo, body, apiMap.getApi().isAsync());
            }
            case "CALLBACK": {
                if (Strings.isNullOrEmpty((String)headers.getHeaderString("X-CALLBACK-URI"))) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                return this.executeCommandAsync(service, apiMap.getApi(), method, path, headers, uriInfo, body, apiMap.getApi().isAsync());
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private Response executeInline(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws IOException, TimeoutException {
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand(service);
        RevolverHttpResponse response = (RevolverHttpResponse)httpCommand.execute(RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(headers.getHeaderString("X-REQUEST-ID")).transactionId(headers.getHeaderString("X-TRANSACTION-ID")).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap<String, String>)sanatizedHeaders).queryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).body(body).build());
        return this.transform(headers, response);
    }

    private Response transform(HttpHeaders headers, RevolverHttpResponse response) throws IOException {
        String requestMediaType;
        Response.ResponseBuilder httpResponse = Response.status((int)response.getStatusCode());
        response.getHeaders().keySet().parallelStream().filter(h -> !h.equalsIgnoreCase("Content-Type")).filter(h -> !h.equalsIgnoreCase("Content-Length")).forEach(h -> httpResponse.header(h, response.getHeaders().getFirst(h)));
        String responseMediaType = Strings.isNullOrEmpty((String)((String)response.getHeaders().getFirst((Object)"Content-Type"))) ? "application/octet-stream" : (String)response.getHeaders().getFirst((Object)"Content-Type");
        String string = requestMediaType = Strings.isNullOrEmpty((String)headers.getHeaderString("Accept")) ? null : headers.getHeaderString("Accept");
        if (Strings.isNullOrEmpty((String)requestMediaType) || requestMediaType.equals(responseMediaType)) {
            httpResponse.header("Content-Type", (Object)responseMediaType);
            httpResponse.entity((Object)response.getBody());
            return httpResponse.build();
        }
        Object responseData = null;
        if (responseMediaType.startsWith("application/json")) {
            JsonNode jsonNode = this.jsonObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.jsonObjectMapper.convertValue((Object)jsonNode, List.class) : this.jsonObjectMapper.convertValue((Object)jsonNode, Map.class);
        } else if (responseMediaType.startsWith("application/xml")) {
            JsonNode jsonNode = this.xmlObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.xmlObjectMapper.convertValue((Object)jsonNode, List.class) : this.xmlObjectMapper.convertValue((Object)jsonNode, Map.class);
        } else if (responseMediaType.startsWith("application/msgpack")) {
            JsonNode jsonNode = this.msgPackObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.msgPackObjectMapper.convertValue((Object)jsonNode, List.class) : this.msgPackObjectMapper.convertValue((Object)jsonNode, Map.class);
        }
        if (responseData == null) {
            httpResponse.entity((Object)response.getBody());
        } else if (requestMediaType.startsWith("application/json")) {
            httpResponse.header("Content-Type", (Object)"application/json");
            httpResponse.entity((Object)this.jsonObjectMapper.writeValueAsBytes(responseData));
        } else if (requestMediaType.startsWith("application/xml")) {
            httpResponse.header("Content-Type", (Object)"application/xml");
            httpResponse.entity((Object)this.xmlObjectMapper.writer().withRootName("Response").writeValueAsBytes(responseData));
        } else if (requestMediaType.startsWith("application/msgpack")) {
            httpResponse.header("Content-Type", (Object)"application/msgpack");
            httpResponse.entity((Object)this.msgPackObjectMapper.writeValueAsBytes(responseData));
        } else {
            httpResponse.header("Content-Type", (Object)"application/json");
            httpResponse.entity((Object)this.jsonObjectMapper.writeValueAsBytes(responseData));
        }
        return httpResponse.build();
    }

    private void cleanHeaders(MultivaluedMap<String, String> headers, RevolverHttpApiConfig apiConfig) {
        headers.remove((Object)"Host");
        headers.remove((Object)"Accept");
        headers.remove((Object)"Accept-Encoding");
        headers.putSingle((Object)"Accept", (Object)apiConfig.getAcceptEncoding());
        headers.putSingle((Object)"Accept-Encoding", (Object)apiConfig.getAcceptEncoding());
    }

    private Response executeCommandAsync(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body, boolean isDownstreamAsync) throws Exception {
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand(service);
        String requestId = headers.getHeaderString("X-REQUEST-ID");
        String transactionId = headers.getHeaderString("X-TRANSACTION-ID");
        String mailBoxId = headers.getHeaderString("X-MAILBOX-ID");
        if (this.persistenceProvider.exists(requestId)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity(Collections.singletonMap("message", "Duplicate")).build();
        }
        this.persistenceProvider.saveRequest(requestId, mailBoxId, RevolverCallbackRequest.builder().api(api.getApi()).mode((String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE")).callbackUri((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-URI")).method((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-METHOD")).service(service).path(path).headers((Map<String, List<String>>)headers.getRequestHeaders()).queryParams((Map<String, List<String>>)uriInfo.getQueryParameters()).body(body).build());
        CompletableFuture response = httpCommand.executeAsync(RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(requestId).transactionId(transactionId).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap<String, String>)sanatizedHeaders).queryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).body(body).build());
        if (isDownstreamAsync) {
            RevolverHttpResponse result2 = (RevolverHttpResponse)response.get();
            if (result2.getStatusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED);
                return this.transform(headers, result2);
            }
            this.persistenceProvider.setRequestState(requestId, RevolverRequestState.RESPONDED);
            this.saveResponse(requestId, result2);
            return this.transform(headers, result2);
        }
        response.thenAcceptAsync(result -> {
            if (result.getStatusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED);
            } else if (result.getStatusCode() == Response.Status.OK.getStatusCode()) {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.RESPONDED);
                this.saveResponse(requestId, (RevolverHttpResponse)result);
            } else {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.ERROR);
                this.saveResponse(requestId, (RevolverHttpResponse)result);
            }
        });
        return Response.accepted().entity((Object)RevolverAckMessage.builder().requestId(requestId).acceptedAt(Instant.now().toEpochMilli()).build()).build();
    }

    private void saveResponse(String requestId, RevolverHttpResponse result) {
        try {
            this.persistenceProvider.saveResponse(requestId, RevolverCallbackResponse.builder().body(result.getBody()).headers((Map<String, List<String>>)result.getHeaders()).statusCode(result.getStatusCode()).build());
        }
        catch (Exception e) {
            log.error("Error saving response!", (Throwable)e);
        }
    }
}

