/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.persistence;

import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.revolver.aeroapike.AerospikeConnectionManager;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeroSpikePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = LoggerFactory.getLogger(AeroSpikePersistenceProvider.class);
    private final AerospikeMailBoxConfig mailBoxConfig;
    private final ObjectMapper objectMapper;
    private static String MAILBOX_SET_NAME = "mailbox_messages";

    public AeroSpikePersistenceProvider(AerospikeMailBoxConfig mailBoxConfig, ObjectMapper objectMapper) {
        this.mailBoxConfig = mailBoxConfig;
        this.objectMapper = objectMapper;
        IndexTask idxMailboxId = AerospikeConnectionManager.getClient().createIndex(null, mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, "idx_mailbox_id", "mailbox_id", IndexType.STRING);
        idxMailboxId.waitTillComplete();
        IndexTask idxMessageState = AerospikeConnectionManager.getClient().createIndex(null, mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, "idx_message_state", "state", IndexType.STRING);
        idxMailboxId.waitTillComplete();
        idxMessageState.waitTillComplete();
    }

    @Override
    public boolean exists(String requestId) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        return AerospikeConnectionManager.getClient().exists(null, key);
    }

    @Override
    public void saveRequest(String requestId, String mailboxId, RevolverCallbackRequest request) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        try {
            Bin service = new Bin("service", request.getService());
            Bin api = new Bin("api", request.getApi());
            Bin mode = new Bin("mode", request.getMode());
            Bin method = new Bin("method", request.getMethod());
            Bin path = new Bin("path", request.getPath());
            Bin mailBoxId = new Bin("mailbox_id", mailboxId == null ? "NONE" : mailboxId);
            Bin queryParams = new Bin("query_params", this.objectMapper.writeValueAsString(request.getQueryParams()));
            Bin callbackUri = new Bin("callback_uri", request.getCallbackUri());
            Bin requestHeaders = new Bin("request_headers", this.objectMapper.writeValueAsString(request.getHeaders()));
            Bin requestBody = new Bin("request_body", request.getBody());
            Bin requestTime = new Bin("request_time", Instant.now().toEpochMilli());
            Bin created = new Bin("created", Instant.now().toEpochMilli());
            Bin updated = new Bin("updated", Instant.now().toEpochMilli());
            Bin state = new Bin("state", RevolverRequestState.RECEIVED.name());
            AerospikeConnectionManager.getClient().put(null, key, new Bin[]{service, api, mode, method, path, mailBoxId, queryParams, callbackUri, requestHeaders, requestBody, requestTime, created, updated, state});
        }
        catch (JsonProcessingException e) {
            log.warn("Error encoding request", (Throwable)e);
        }
    }

    @Override
    public void setRequestState(String requestId, RevolverRequestState state) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Bin binState = new Bin("state", state.name());
        Bin updated = new Bin("updated", Instant.now().toEpochMilli());
        AerospikeConnectionManager.getClient().operate(null, key, new Operation[]{Operation.put((Bin)binState), Operation.put((Bin)updated)});
    }

    @Override
    public void saveResponse(String requestId, RevolverCallbackResponse response) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Bin state = new Bin("state", RevolverRequestState.RESPONDED.name());
        try {
            Bin responseHeaders = new Bin("response_headers", this.objectMapper.writeValueAsString(response.getHeaders()));
            Bin responseBody = new Bin("response_body", response.getBody());
            Bin responseStatusCode = new Bin("response_status_code", response.getStatusCode());
            Bin responseTime = new Bin("response_time", Instant.now().toEpochMilli());
            Bin updated = new Bin("updated", Instant.now().toEpochMilli());
            AerospikeConnectionManager.getClient().operate(null, key, new Operation[]{Operation.put((Bin)state), Operation.put((Bin)responseHeaders), Operation.put((Bin)responseBody), Operation.put((Bin)responseStatusCode), Operation.put((Bin)responseTime), Operation.put((Bin)updated)});
        }
        catch (JsonProcessingException e) {
            log.warn("Error encoding response headers", (Throwable)e);
        }
    }

    @Override
    public RevolverRequestState requestState(String requestId) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(null, key, new String[]{"state"});
        if (record == null) {
            return RevolverRequestState.UNKNOWN;
        }
        return RevolverRequestState.valueOf(record.getString("state"));
    }

    @Override
    public RevolverCallbackResponse response(String requestId) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(null, key);
        if (record == null) {
            return null;
        }
        return this.recordToResponse(record);
    }

    @Override
    public List<RevolverCallbackResponse> responses(String mailboxId) {
        Statement statement = new Statement();
        statement.setNamespace(this.mailBoxConfig.getNamespace());
        statement.setSetName(MAILBOX_SET_NAME);
        statement.setIndexName("idx_mailbox_id");
        statement.setFilters(new Filter[]{Filter.equal((String)"mailbox_id", (String)mailboxId)});
        ArrayList<RevolverCallbackResponse> responses = new ArrayList<RevolverCallbackResponse>();
        try (RecordSet records = AerospikeConnectionManager.getClient().query(null, statement);){
            while (records.next()) {
                responses.add(this.recordToResponse(records.getRecord()));
            }
        }
        return responses;
    }

    @Override
    public RevolverCallbackRequest request(String requestId) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(null, key);
        if (record == null) {
            return null;
        }
        return this.recordToRequest(record);
    }

    @Override
    public List<RevolverCallbackRequest> requests(String mailboxId) {
        Statement statement = new Statement();
        statement.setNamespace(this.mailBoxConfig.getNamespace());
        statement.setSetName(MAILBOX_SET_NAME);
        statement.setIndexName("idx_mailbox_id");
        statement.setFilters(new Filter[]{Filter.equal((String)"mailbox_id", (String)mailboxId)});
        ArrayList<RevolverCallbackRequest> requests = new ArrayList<RevolverCallbackRequest>();
        try (RecordSet records = AerospikeConnectionManager.getClient().query(null, statement);){
            while (records.next()) {
                requests.add(this.recordToRequest(records.getRecord()));
            }
        }
        return requests;
    }

    private RevolverCallbackRequest recordToRequest(Record record) {
        Map<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, List<String>> queryParams = new HashMap();
        try {
            headers = (Map)this.objectMapper.readValue(record.getString("request_headers"), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
            queryParams = (Map)this.objectMapper.readValue(record.getString("query_params"), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        }
        catch (IOException e) {
            log.warn("Error decoding response", (Throwable)e);
        }
        return RevolverCallbackRequest.builder().headers(headers).api(record.getString("api")).callbackUri(record.getString("callback_uri")).body(record.getValue("request_body") == null ? null : (byte[])record.getValue("request_body")).method(record.getString("method")).mode(record.getString("mode")).path(record.getString("path")).queryParams(queryParams).service(record.getString("service")).build();
    }

    private RevolverCallbackResponse recordToResponse(Record record) {
        HashMap<String, List<String>> headers = new HashMap();
        try {
            headers = (Map)this.objectMapper.readValue(record.getString("response_headers"), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        }
        catch (IOException e) {
            log.warn("Error decoding response headers", (Throwable)e);
        }
        return RevolverCallbackResponse.builder().body((byte[])record.getValue("response_body")).statusCode(record.getInt("response_status_code")).headers(headers).build();
    }

    private static interface BinNames {
        public static final String MAILBOX_ID = "mailbox_id";
        public static final String SERVICE = "service";
        public static final String API = "api";
        public static final String MODE = "mode";
        public static final String METHOD = "method";
        public static final String PATH = "path";
        public static final String QUERY_PARAMS = "query_params";
        public static final String CALLBACK_URI = "callback_uri";
        public static final String REQUEST_HEADERS = "request_headers";
        public static final String REQUEST_BODY = "request_body";
        public static final String REQUEST_TIME = "request_time";
        public static final String RESPONSE_HEADERS = "response_headers";
        public static final String RESPONSE_BODY = "response_body";
        public static final String RESPONSE_TIME = "response_time";
        public static final String RESPONSE_STATUS_CODE = "response_status_code";
        public static final String CREATED = "created";
        public static final String UPDATED = "updated";
        public static final String STATE = "state";
    }
}

