/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.handler;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import io.dropwizard.revolver.core.config.RevolverConfig;
import java.io.IOException;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
public class RevolverCallbackRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RevolverCallbackRequestFilter.class);
    private static final String FORWARDED_FOR = "X-FORWARDED-FOR";
    private final RevolverConfig config;

    public RevolverCallbackRequestFilter(RevolverConfig config) {
        this.config = config;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        String requestId = containerRequestContext.getHeaderString("X-REQUEST-ID");
        String transactionId = containerRequestContext.getHeaderString("X-TRANSACTION-ID");
        String host = containerRequestContext.getHeaderString("Host");
        containerRequestContext.getHeaders().add((Object)FORWARDED_FOR, (Object)host);
        if (Strings.isNullOrEmpty((String)requestId)) {
            requestId = UUID.randomUUID().toString();
            containerRequestContext.getHeaders().add((Object)"X-REQUEST-ID", (Object)requestId);
        }
        if (Strings.isNullOrEmpty((String)transactionId)) {
            containerRequestContext.getHeaders().add((Object)"X-TRANSACTION-ID", (Object)requestId);
        }
        if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-REQUEST-TIMESTAMP"))) {
            containerRequestContext.getHeaders().add((Object)"X-REQUEST-TIMESTAMP", (Object)Instant.now().toString());
        }
        if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("Accept"))) {
            containerRequestContext.getHeaders().add((Object)"Accept", (Object)"application/json");
        }
        if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("Content-Type"))) {
            containerRequestContext.getHeaders().add((Object)"Content-Type", (Object)"application/json");
        }
        if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("Content-Encoding"))) {
            containerRequestContext.getHeaders().add((Object)"Content-Encoding", (Object)Charsets.UTF_8.name());
        }
        if (!Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-CALLBACK-URI"))) {
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-CALLBACK-TIMEOUT"))) {
                containerRequestContext.getHeaders().add((Object)"X-CALLBACK-TIMEOUT", (Object)String.valueOf(this.config.getCallbackTimeout()));
            }
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-CALLBACK-METHOD"))) {
                containerRequestContext.getHeaders().add((Object)"X-CALLBACK-METHOD", (Object)"POST");
            }
        }
    }
}

