/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.model;

import io.dropwizard.revolver.core.model.RevolverResponse;
import java.util.Arrays;
import javax.ws.rs.core.MultivaluedMap;

public class RevolverHttpResponse
extends RevolverResponse {
    private int statusCode;

    public RevolverHttpResponse(MultivaluedMap<String, String> headers, byte[] body, int statusCode) {
        super(headers, body);
        this.statusCode = statusCode;
    }

    public static RevolverHttpResponseBuilder builder() {
        return new RevolverHttpResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpResponse)) {
            return false;
        }
        RevolverHttpResponse other = (RevolverHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getStatusCode() == other.getStatusCode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getStatusCode();
        return result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public String toString() {
        return "RevolverHttpResponse(statusCode=" + this.getStatusCode() + ")";
    }

    public RevolverHttpResponse() {
    }

    public static class RevolverHttpResponseBuilder {
        private MultivaluedMap<String, String> headers;
        private byte[] body;
        private int statusCode;

        RevolverHttpResponseBuilder() {
        }

        public RevolverHttpResponseBuilder headers(MultivaluedMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public RevolverHttpResponseBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public RevolverHttpResponseBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public RevolverHttpResponse build() {
            return new RevolverHttpResponse(this.headers, this.body, this.statusCode);
        }

        public String toString() {
            return "RevolverHttpResponse.RevolverHttpResponseBuilder(headers=" + this.headers + ", body=" + Arrays.toString(this.body) + ", statusCode=" + this.statusCode + ")";
        }
    }
}

