/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.revolver.http.auth.BasicAuthConfig;
import io.dropwizard.revolver.http.auth.TokenAuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CipherSuite;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpClientFactory.class);
    private static LoadingCache<RevolverHttpServiceConfig, OkHttpClient> clientCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<RevolverHttpServiceConfig, OkHttpClient>(){

        public OkHttpClient load(RevolverHttpServiceConfig serviceConfiguration) throws Exception {
            return RevolverHttpClientFactory.getOkHttpClient(serviceConfiguration);
        }
    });

    public static OkHttpClient buildClient(RevolverHttpServiceConfig serviceConfiguration) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, UnrecoverableKeyException, ExecutionException {
        Preconditions.checkNotNull((Object)serviceConfiguration);
        return (OkHttpClient)clientCache.get((Object)serviceConfiguration);
    }

    private static OkHttpClient getOkHttpClient(RevolverHttpServiceConfig serviceConfiguration) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (serviceConfiguration.isAuthEnabled()) {
            switch (serviceConfiguration.getAuth().getType().toLowerCase()) {
                case "basic": {
                    BasicAuthConfig basicAuthConfig = (BasicAuthConfig)serviceConfiguration.getAuth();
                    if (!Strings.isNullOrEmpty((String)basicAuthConfig.getUsername())) {
                        throw new RuntimeException(String.format("No valid authentication data for service %s", serviceConfiguration.getAuth().getType()));
                    }
                    builder.authenticator((route, response) -> {
                        String credentials = Credentials.basic((String)basicAuthConfig.getUsername(), (String)basicAuthConfig.getPassword());
                        return response.request().newBuilder().addHeader("Authorization", credentials).build();
                    });
                    break;
                }
                case "token": {
                    TokenAuthConfig tokenAuthConfig = (TokenAuthConfig)serviceConfiguration.getAuth();
                    if (Strings.isNullOrEmpty((String)tokenAuthConfig.getPrefix())) {
                        builder.authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", tokenAuthConfig.getToken()).build());
                        break;
                    }
                    builder.authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", String.format("%s %s", tokenAuthConfig.getPrefix(), tokenAuthConfig.getToken())).build());
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Authentication type %s is not supported", serviceConfiguration.getAuth().getType()));
                }
            }
        }
        if (serviceConfiguration.isSecured()) {
            String keystorePath = serviceConfiguration.getKeyStorePath();
            String keystorePassword = serviceConfiguration.getKeystorePassword() == null ? "" : serviceConfiguration.getKeystorePassword();
            ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.COMPATIBLE_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_1}).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256}).build();
            builder.connectionSpecs(Collections.singletonList(spec));
            if (!StringUtils.isBlank((CharSequence)keystorePath)) {
                builder.socketFactory((SocketFactory)RevolverHttpClientFactory.getSSLContext(keystorePath, keystorePassword).getSocketFactory());
            } else {
                builder.socketFactory((SocketFactory)RevolverHttpClientFactory.getSSLContext().getSocketFactory());
            }
        }
        if (serviceConfiguration.getConnectionKeepAliveInMillis() <= 0) {
            builder.connectionPool(new ConnectionPool(serviceConfiguration.getConnectionPoolSize(), 5L, TimeUnit.MINUTES));
        } else {
            builder.connectionPool(new ConnectionPool(serviceConfiguration.getConnectionPoolSize(), (long)serviceConfiguration.getConnectionKeepAliveInMillis(), TimeUnit.MILLISECONDS));
        }
        builder.connectTimeout((long)serviceConfiguration.getRuntime().getThreadPool().getTimeout(), TimeUnit.MILLISECONDS);
        return builder.build();
    }

    private static SSLContext getSSLContext(String keyStorePath, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream instream = RevolverHttpClientFactory.class.getClassLoader().getResourceAsStream(keyStorePath);){
            keyStore.load(instream, keyStorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private static SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = new TrustManager[]{new TrustEveryoneManager()};
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }

    static class TrustEveryoneManager
    implements X509TrustManager {
        TrustEveryoneManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

