/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.tracing;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;

public class TraceInfo {
    private String transactionId;
    private String requestId;
    private String parentRequestId;
    private long timestamp;
    private Map<String, String> attributes;

    public TraceInfo() {
        this.requestId = this.transactionId = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
    }

    public static TraceInfoBuilder builder() {
        return new TraceInfoBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getParentRequestId() {
        return this.parentRequestId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setParentRequestId(String parentRequestId) {
        this.parentRequestId = parentRequestId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceInfo)) {
            return false;
        }
        TraceInfo other = (TraceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$parentRequestId = this.getParentRequestId();
        String other$parentRequestId = other.getParentRequestId();
        if (this$parentRequestId == null ? other$parentRequestId != null : !this$parentRequestId.equals(other$parentRequestId)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TraceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $parentRequestId = this.getParentRequestId();
        result = result * 59 + ($parentRequestId == null ? 43 : $parentRequestId.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "TraceInfo(transactionId=" + this.getTransactionId() + ", requestId=" + this.getRequestId() + ", parentRequestId=" + this.getParentRequestId() + ", timestamp=" + this.getTimestamp() + ", attributes=" + this.getAttributes() + ")";
    }

    @ConstructorProperties(value={"transactionId", "requestId", "parentRequestId", "timestamp", "attributes"})
    public TraceInfo(String transactionId, String requestId, String parentRequestId, long timestamp, Map<String, String> attributes) {
        this.transactionId = transactionId;
        this.requestId = requestId;
        this.parentRequestId = parentRequestId;
        this.timestamp = timestamp;
        this.attributes = attributes;
    }

    public static class TraceInfoBuilder {
        private String transactionId;
        private String requestId;
        private String parentRequestId;
        private long timestamp;
        private Map<String, String> attributes;

        TraceInfoBuilder() {
        }

        public TraceInfoBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public TraceInfoBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public TraceInfoBuilder parentRequestId(String parentRequestId) {
            this.parentRequestId = parentRequestId;
            return this;
        }

        public TraceInfoBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TraceInfoBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public TraceInfo build() {
            return new TraceInfo(this.transactionId, this.requestId, this.parentRequestId, this.timestamp, this.attributes);
        }

        public String toString() {
            return "TraceInfo.TraceInfoBuilder(transactionId=" + this.transactionId + ", requestId=" + this.requestId + ", parentRequestId=" + this.parentRequestId + ", timestamp=" + this.timestamp + ", attributes=" + this.attributes + ")";
        }
    }
}

