/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.callback;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandler.class);
    private PersistenceProvider persistenceProvider;
    private RevolverConfig revolverConfig;
    private LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> clientLoadingCache;

    public CallbackHandler(PersistenceProvider persistenceProvider, RevolverConfig revolverConfig) {
        this.persistenceProvider = persistenceProvider;
        this.revolverConfig = revolverConfig;
        this.clientLoadingCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CallbackConfigKey, RevolverHttpServiceConfig>(){

            public RevolverHttpServiceConfig load(CallbackConfigKey key) throws Exception {
                return CallbackHandler.this.buildConfiguration(key.callbackRequest, key.endpoint);
            }
        });
    }

    public void handle(String requestId) {
        RevolverCallbackRequest request = this.persistenceProvider.request(requestId);
        if (request == null) {
            log.warn("Invalid request: {}", (Object)requestId);
            return;
        }
        RevolverRequestState state = this.persistenceProvider.requestState(requestId);
        if (state == null) {
            log.warn("Invalid request state: {}", (Object)requestId);
            return;
        }
        if (state != RevolverRequestState.RESPONDED) {
            log.warn("Invalid request state {}: {}", (Object)state.name(), (Object)requestId);
            return;
        }
        if (Strings.isNullOrEmpty((String)request.getCallbackUri())) {
            log.warn("Invalid callback uri: {}", (Object)requestId);
            return;
        }
        try {
            URI uri = new URI(request.getCallbackUri());
            switch (uri.getScheme()) {
                case "https": 
                case "http": 
                case "ranger": {
                    this.makeCallback(requestId, uri, request);
                    break;
                }
                default: {
                    log.warn("Invalid protocol for request: {}", (Object)requestId);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Invalid callback uri {} for request: {}", new Object[]{request.getCallbackUri(), requestId, e});
        }
    }

    private void makeCallback(String requestId, URI uri, RevolverCallbackRequest callbackRequest) {
        RevolverCallbackResponse response = this.persistenceProvider.response(requestId);
        if (response == null) {
            log.warn("Invalid response: {}", (Object)requestId);
            return;
        }
        try {
            RevolverHttpServiceConfig httpCommandConfig = (RevolverHttpServiceConfig)this.clientLoadingCache.get((Object)CallbackConfigKey.builder().callbackRequest(callbackRequest).endpoint(uri.getScheme() + "://" + uri.getHost() + ":" + (uri.getPort() != -1 ? Integer.valueOf(uri.getPort()) : "")).build());
            RevolverHttpCommand httpCommand = this.getCommand(httpCommandConfig);
            MultivaluedHashMap requestHeaders = new MultivaluedHashMap();
            response.getHeaders().forEach((arg_0, arg_1) -> ((MultivaluedMap)requestHeaders).put(arg_0, arg_1));
            requestHeaders.remove((Object)"Host");
            requestHeaders.putSingle((Object)"X-RESPONSE-CODE", (Object)String.valueOf(response.getStatusCode()));
            String method = callbackRequest.getHeaders().getOrDefault("X-CALLBACK-METHOD", Collections.singletonList("POST")).get(0);
            method = Strings.isNullOrEmpty((String)method) ? "POST" : method;
            RevolverHttpRequest httpRequest = RevolverHttpRequest.builder().path(uri.getRawPath()).api("callback").body(response.getBody() == null ? new byte[]{} : response.getBody()).headers((MultivaluedMap<String, String>)requestHeaders).method(RevolverHttpApiConfig.RequestMethod.valueOf(method)).service(httpCommandConfig.getService()).build();
            CompletableFuture httpResponseFuture = httpCommand.executeAsync(httpRequest);
            httpResponseFuture.thenAcceptAsync(httpResponse -> {
                if (httpResponse.getStatusCode() >= 200 && httpResponse.getStatusCode() <= 210) {
                    log.debug("Callback success: " + httpResponse.toString());
                } else {
                    log.error("Error from callback host: {} | Status Code: {} | Response Body: ", new Object[]{uri.getHost(), httpResponse.getStatusCode(), httpResponse.getBody() != null ? new String(httpResponse.getBody()) : "NONE"});
                }
            });
        }
        catch (MalformedURLException e) {
            log.error("Invalid callback URL: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (IOException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (CertificateException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (UnrecoverableKeyException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (KeyStoreException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (KeyManagementException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
        catch (ExecutionException e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
    }

    private RevolverHttpServiceConfig buildConfiguration(RevolverCallbackRequest callbackRequest, String endpoint) throws MalformedURLException, URISyntaxException {
        EndpointSpec endpointSpec = null;
        String apiName = "callback";
        URI uri = new URI(endpoint);
        String serviceName = uri.getHost().replace(".", "-");
        String type = null;
        String method = callbackRequest.getHeaders().getOrDefault("X-CALLBACK-METHOD", Collections.singletonList("POST")).get(0);
        method = Strings.isNullOrEmpty((String)method) ? "POST" : method;
        String timeout = callbackRequest.getHeaders().getOrDefault("X-CALLBACK-TIMEOUT", Collections.singletonList(String.valueOf(this.revolverConfig.getCallbackTimeout()))).get(0);
        timeout = Strings.isNullOrEmpty((String)timeout) ? String.valueOf(this.revolverConfig.getCallbackTimeout()) : timeout;
        switch (uri.getScheme()) {
            case "https": 
            case "http": {
                SimpleEndpointSpec simpleEndpoint = new SimpleEndpointSpec();
                simpleEndpoint.setHost(uri.getHost());
                simpleEndpoint.setPort(uri.getPort() == 0 || uri.getPort() == -1 ? 80 : uri.getPort());
                endpointSpec = simpleEndpoint;
                type = uri.getScheme();
                break;
            }
            case "ranger": {
                RangerEndpointSpec rangerEndpoint = new RangerEndpointSpec();
                String[] discoveryData = uri.getHost().split("\\.");
                if (discoveryData.length != 3) {
                    throw new MalformedURLException("Invalid ranger host format. Accepted format is environment.service.api");
                }
                rangerEndpoint.setEnvironment(discoveryData[0]);
                rangerEndpoint.setService(discoveryData[1]);
                endpointSpec = rangerEndpoint;
                type = "ranger_sharded";
                apiName = discoveryData[2];
            }
        }
        return RevolverHttpServiceConfig.builder().authEnabled(false).connectionPoolSize(10).secured(uri.getScheme().equals("https")).enpoint(endpointSpec).service(serviceName).type(type).api(RevolverHttpApiConfig.configBuilder().api(apiName).method(RevolverHttpApiConfig.RequestMethod.valueOf(method)).path(null).runtime(HystrixCommandConfig.builder().threadPool(ThreadPoolConfig.builder().concurrency(10).timeout(Integer.parseInt(timeout)).build()).build()).build()).build();
    }

    private RevolverHttpCommand getCommand(RevolverHttpServiceConfig httpConfig) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, ExecutionException {
        try {
            return RevolverBundle.getHttpCommand(httpConfig.getService());
        }
        catch (RevolverExecutionException e) {
            RevolverBundle.addHttpCommand(httpConfig.getService(), RevolverHttpCommand.builder().clientConfiguration(this.revolverConfig.getClientConfig()).runtimeConfig(this.revolverConfig.getGlobal()).serviceConfiguration(httpConfig).apiConfigurations(this.generateApiConfigMap(httpConfig)).serviceResolver(RevolverBundle.getServiceNameResolver()).traceCollector(trace -> {}).build());
            return RevolverBundle.getHttpCommand(httpConfig.getService());
        }
    }

    private Map<String, RevolverHttpApiConfig> generateApiConfigMap(RevolverHttpServiceConfig serviceConfiguration) {
        return serviceConfiguration.getApis().stream().collect(Collectors.toMap(CommandHandlerConfig::getApi, apiConfig -> apiConfig));
    }

    public static CallbackHandlerBuilder builder() {
        return new CallbackHandlerBuilder();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> getClientLoadingCache() {
        return this.clientLoadingCache;
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public void setClientLoadingCache(LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> clientLoadingCache) {
        this.clientLoadingCache = clientLoadingCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallbackHandler)) {
            return false;
        }
        CallbackHandler other = (CallbackHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PersistenceProvider this$persistenceProvider = this.getPersistenceProvider();
        PersistenceProvider other$persistenceProvider = other.getPersistenceProvider();
        if (this$persistenceProvider == null ? other$persistenceProvider != null : !this$persistenceProvider.equals(other$persistenceProvider)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        if (this$revolverConfig == null ? other$revolverConfig != null : !this$revolverConfig.equals(other$revolverConfig)) {
            return false;
        }
        LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> this$clientLoadingCache = this.getClientLoadingCache();
        LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> other$clientLoadingCache = other.getClientLoadingCache();
        return !(this$clientLoadingCache == null ? other$clientLoadingCache != null : !this$clientLoadingCache.equals(other$clientLoadingCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallbackHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PersistenceProvider $persistenceProvider = this.getPersistenceProvider();
        result = result * 59 + ($persistenceProvider == null ? 43 : $persistenceProvider.hashCode());
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : $revolverConfig.hashCode());
        LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> $clientLoadingCache = this.getClientLoadingCache();
        result = result * 59 + ($clientLoadingCache == null ? 43 : $clientLoadingCache.hashCode());
        return result;
    }

    public String toString() {
        return "CallbackHandler(persistenceProvider=" + this.getPersistenceProvider() + ", revolverConfig=" + this.getRevolverConfig() + ", clientLoadingCache=" + this.getClientLoadingCache() + ")";
    }

    public static class CallbackHandlerBuilder {
        private PersistenceProvider persistenceProvider;
        private RevolverConfig revolverConfig;

        CallbackHandlerBuilder() {
        }

        public CallbackHandlerBuilder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public CallbackHandlerBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public CallbackHandler build() {
            return new CallbackHandler(this.persistenceProvider, this.revolverConfig);
        }

        public String toString() {
            return "CallbackHandler.CallbackHandlerBuilder(persistenceProvider=" + this.persistenceProvider + ", revolverConfig=" + this.revolverConfig + ")";
        }
    }

    public static class CallbackConfigKey {
        private String endpoint;
        private RevolverCallbackRequest callbackRequest;

        public static CallbackConfigKeyBuilder builder() {
            return new CallbackConfigKeyBuilder();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public RevolverCallbackRequest getCallbackRequest() {
            return this.callbackRequest;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setCallbackRequest(RevolverCallbackRequest callbackRequest) {
            this.callbackRequest = callbackRequest;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallbackConfigKey)) {
                return false;
            }
            CallbackConfigKey other = (CallbackConfigKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CallbackConfigKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            return result;
        }

        public String toString() {
            return "CallbackHandler.CallbackConfigKey(endpoint=" + this.getEndpoint() + ")";
        }

        @ConstructorProperties(value={"endpoint", "callbackRequest"})
        public CallbackConfigKey(String endpoint, RevolverCallbackRequest callbackRequest) {
            this.endpoint = endpoint;
            this.callbackRequest = callbackRequest;
        }

        public static class CallbackConfigKeyBuilder {
            private String endpoint;
            private RevolverCallbackRequest callbackRequest;

            CallbackConfigKeyBuilder() {
            }

            public CallbackConfigKeyBuilder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public CallbackConfigKeyBuilder callbackRequest(RevolverCallbackRequest callbackRequest) {
                this.callbackRequest = callbackRequest;
                return this;
            }

            public CallbackConfigKey build() {
                return new CallbackConfigKey(this.endpoint, this.callbackRequest);
            }

            public String toString() {
                return "CallbackHandler.CallbackConfigKey.CallbackConfigKeyBuilder(endpoint=" + this.endpoint + ", callbackRequest=" + this.callbackRequest + ")";
            }
        }
    }
}

