/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config.hystrix;

import java.beans.ConstructorProperties;

public class ThreadPoolConfig {
    private boolean semaphoreIsolated;
    private int concurrency = 10;
    private int maxRequestQueueSize = 100;
    private int dynamicRequestQueueSize = 10;
    private int timeout = 1000;

    public static ThreadPoolConfigBuilder builder() {
        return new ThreadPoolConfigBuilder();
    }

    public boolean isSemaphoreIsolated() {
        return this.semaphoreIsolated;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getDynamicRequestQueueSize() {
        return this.dynamicRequestQueueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setSemaphoreIsolated(boolean semaphoreIsolated) {
        this.semaphoreIsolated = semaphoreIsolated;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setMaxRequestQueueSize(int maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
    }

    public void setDynamicRequestQueueSize(int dynamicRequestQueueSize) {
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolConfig)) {
            return false;
        }
        ThreadPoolConfig other = (ThreadPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSemaphoreIsolated() != other.isSemaphoreIsolated()) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getMaxRequestQueueSize() != other.getMaxRequestQueueSize()) {
            return false;
        }
        if (this.getDynamicRequestQueueSize() != other.getDynamicRequestQueueSize()) {
            return false;
        }
        return this.getTimeout() == other.getTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSemaphoreIsolated() ? 79 : 97);
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getMaxRequestQueueSize();
        result = result * 59 + this.getDynamicRequestQueueSize();
        result = result * 59 + this.getTimeout();
        return result;
    }

    public String toString() {
        return "ThreadPoolConfig(semaphoreIsolated=" + this.isSemaphoreIsolated() + ", concurrency=" + this.getConcurrency() + ", maxRequestQueueSize=" + this.getMaxRequestQueueSize() + ", dynamicRequestQueueSize=" + this.getDynamicRequestQueueSize() + ", timeout=" + this.getTimeout() + ")";
    }

    @ConstructorProperties(value={"semaphoreIsolated", "concurrency", "maxRequestQueueSize", "dynamicRequestQueueSize", "timeout"})
    public ThreadPoolConfig(boolean semaphoreIsolated, int concurrency, int maxRequestQueueSize, int dynamicRequestQueueSize, int timeout) {
        this.semaphoreIsolated = semaphoreIsolated;
        this.concurrency = concurrency;
        this.maxRequestQueueSize = maxRequestQueueSize;
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
        this.timeout = timeout;
    }

    public ThreadPoolConfig() {
    }

    public static class ThreadPoolConfigBuilder {
        private boolean semaphoreIsolated;
        private int concurrency;
        private int maxRequestQueueSize;
        private int dynamicRequestQueueSize;
        private int timeout;

        ThreadPoolConfigBuilder() {
        }

        public ThreadPoolConfigBuilder semaphoreIsolated(boolean semaphoreIsolated) {
            this.semaphoreIsolated = semaphoreIsolated;
            return this;
        }

        public ThreadPoolConfigBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public ThreadPoolConfigBuilder maxRequestQueueSize(int maxRequestQueueSize) {
            this.maxRequestQueueSize = maxRequestQueueSize;
            return this;
        }

        public ThreadPoolConfigBuilder dynamicRequestQueueSize(int dynamicRequestQueueSize) {
            this.dynamicRequestQueueSize = dynamicRequestQueueSize;
            return this;
        }

        public ThreadPoolConfigBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ThreadPoolConfig build() {
            return new ThreadPoolConfig(this.semaphoreIsolated, this.concurrency, this.maxRequestQueueSize, this.dynamicRequestQueueSize, this.timeout);
        }

        public String toString() {
            return "ThreadPoolConfig.ThreadPoolConfigBuilder(semaphoreIsolated=" + this.semaphoreIsolated + ", concurrency=" + this.concurrency + ", maxRequestQueueSize=" + this.maxRequestQueueSize + ", dynamicRequestQueueSize=" + this.dynamicRequestQueueSize + ", timeout=" + this.timeout + ")";
        }
    }
}

