/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.filters;

import com.google.common.base.Strings;
import io.dropwizard.revolver.core.config.RevolverConfig;
import java.io.IOException;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
@Singleton
public class RevolverRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RevolverRequestFilter.class);
    private static final String FORWARDED_FOR = "X-FORWARDED-FOR";
    private final RevolverConfig config;

    public RevolverRequestFilter(RevolverConfig config) {
        this.config = config;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (!containerRequestContext.getUriInfo().getPath().startsWith("revolver/v1")) {
            String requestId = containerRequestContext.getHeaderString("X-REQUEST-ID");
            String transactionId = containerRequestContext.getHeaderString("X-TRANSACTION-ID");
            if (Strings.isNullOrEmpty((String)requestId)) {
                requestId = UUID.randomUUID().toString();
                containerRequestContext.getHeaders().add((Object)"X-REQUEST-ID", (Object)requestId);
            }
            if (Strings.isNullOrEmpty((String)transactionId)) {
                containerRequestContext.getHeaders().add((Object)"X-TRANSACTION-ID", (Object)requestId);
            }
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-REQUEST-TIMESTAMP"))) {
                containerRequestContext.getHeaders().add((Object)"X-REQUEST-TIMESTAMP", (Object)Instant.now().toString());
            }
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("Accept"))) {
                containerRequestContext.getHeaders().add((Object)"Accept", (Object)"application/json");
            }
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("Content-Type"))) {
                containerRequestContext.getHeaders().add((Object)"Content-Type", (Object)"application/json");
            }
        } else if (!Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-CALLBACK-URI"))) {
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-CALLBACK-TIMEOUT"))) {
                containerRequestContext.getHeaders().add((Object)"X-CALLBACK-TIMEOUT", (Object)String.valueOf(this.config.getCallbackTimeout()));
            }
            if (Strings.isNullOrEmpty((String)containerRequestContext.getHeaderString("X-CALLBACK-METHOD"))) {
                containerRequestContext.getHeaders().add((Object)"X-CALLBACK-METHOD", (Object)"POST");
            }
        }
    }
}

