/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.discovery;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.finder.sharded.SimpleShardedServiceFinder;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.model.ServiceNode;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.discovery.ServiceResolverConfig;
import io.dropwizard.revolver.discovery.SpecVisitor;
import io.dropwizard.revolver.discovery.model.Endpoint;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverServiceResolver {
    private static final Logger log = LoggerFactory.getLogger(RevolverServiceResolver.class);
    private ObjectMapper objectMapper;
    private final boolean discoverEnabled;
    private final CuratorFramework curatorFramework;
    private final ServiceResolverConfig resolverConfig;
    private Map<String, ShardedServiceDiscoveryInfo> serviceFinders = Maps.newConcurrentMap();
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public RevolverServiceResolver(ServiceResolverConfig resolverConfig, ObjectMapper objectMapper) {
        this.resolverConfig = resolverConfig;
        this.objectMapper = objectMapper;
        if (resolverConfig != null) {
            if (!Strings.isNullOrEmpty((String)resolverConfig.getZkConnectionString())) {
                this.curatorFramework = CuratorFrameworkFactory.builder().connectString(resolverConfig.getZkConnectionString()).namespace(resolverConfig.getNamespace()).retryPolicy((RetryPolicy)new RetryNTimes(1000, 500)).build();
                this.curatorFramework.start();
                this.discoverEnabled = true;
            } else {
                this.discoverEnabled = false;
                this.curatorFramework = null;
            }
        } else {
            this.discoverEnabled = false;
            this.curatorFramework = null;
        }
    }

    public RevolverServiceResolver(ServiceResolverConfig resolverConfig, ObjectMapper objectMapper, CuratorFramework curatorFramework) {
        this.resolverConfig = resolverConfig;
        this.objectMapper = objectMapper;
        this.curatorFramework = curatorFramework;
        this.discoverEnabled = true;
    }

    public Endpoint resolve(EndpointSpec endpointSpecification) {
        return new SpecResolver(this.discoverEnabled, this.serviceFinders).resolve(endpointSpecification);
    }

    public void register(EndpointSpec endpointSpecification) {
        endpointSpecification.accept(new SpecVisitor(){

            @Override
            public void visit(SimpleEndpointSpec simpleEndpointSpecification) {
                log.info("Initialized simple service: " + simpleEndpointSpecification.getHost());
            }

            @Override
            public void visit(RangerEndpointSpec rangerEndpointSpecification) {
                try {
                    SimpleShardedServiceFinder serviceFinder = (SimpleShardedServiceFinder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(RevolverServiceResolver.this.curatorFramework).withNamespace(RevolverServiceResolver.this.resolverConfig.getNamespace()).withServiceName(rangerEndpointSpecification.getService()).withDeserializer(data -> {
                        try {
                            JsonNode nodeInfoRoot = RevolverServiceResolver.this.objectMapper.readTree(data);
                            if (nodeInfoRoot.has("node_data")) {
                                ServiceNode serviceNode = new ServiceNode(nodeInfoRoot.get("host").asText(), nodeInfoRoot.get("port").asInt(), RevolverServiceResolver.this.objectMapper.treeToValue((TreeNode)nodeInfoRoot.get("node_data"), ShardInfo.class));
                                serviceNode.setHealthcheckStatus(HealthcheckStatus.valueOf((String)nodeInfoRoot.get("healthcheck_status").asText()));
                                serviceNode.setLastUpdatedTimeStamp(nodeInfoRoot.get("last_updated_time_stamp").asLong());
                                return serviceNode;
                            }
                            return (ServiceNode)RevolverServiceResolver.this.objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error deserializing results", e);
                        }
                    }).build();
                    RevolverServiceResolver.this.serviceFinders.put(rangerEndpointSpecification.getService(), ShardedServiceDiscoveryInfo.builder().environment(rangerEndpointSpecification.getEnvironment()).shardFinder((SimpleShardedServiceFinder<ShardInfo>)serviceFinder).build());
                    RevolverServiceResolver.this.executorService.submit(() -> {
                        try {
                            log.info("Service finder starting for: " + rangerEndpointSpecification.getService());
                            serviceFinder.start();
                        }
                        catch (Exception e) {
                            log.error("Error registering service finder started for: " + rangerEndpointSpecification.getService(), (Throwable)e);
                        }
                        return null;
                    });
                    log.info("Initialized ZK service: " + rangerEndpointSpecification.getService());
                }
                catch (Exception e) {
                    log.error("Error registering hander for service: " + rangerEndpointSpecification.getService(), (Throwable)e);
                }
            }
        });
    }

    public static RevolverServiceResolverBuilder builder() {
        return new RevolverServiceResolverBuilder();
    }

    public static RevolverServiceResolverBuilder usingCurator() {
        return new RevolverServiceResolverBuilder();
    }

    public Map<String, ShardedServiceDiscoveryInfo> getServiceFinders() {
        return this.serviceFinders;
    }

    public static class RevolverServiceResolverBuilder {
        private ServiceResolverConfig resolverConfig;
        private ObjectMapper objectMapper;
        private CuratorFramework curatorFramework;

        RevolverServiceResolverBuilder() {
        }

        public RevolverServiceResolverBuilder resolverConfig(ServiceResolverConfig resolverConfig) {
            this.resolverConfig = resolverConfig;
            return this;
        }

        public RevolverServiceResolverBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public RevolverServiceResolver build() {
            return new RevolverServiceResolver(this.resolverConfig, this.objectMapper);
        }

        public String toString() {
            return "RevolverServiceResolver.RevolverServiceResolverBuilder(resolverConfig=" + this.resolverConfig + ", objectMapper=" + this.objectMapper + ")";
        }

        public RevolverServiceResolverBuilder curatorFramework(CuratorFramework curatorFramework) {
            this.curatorFramework = curatorFramework;
            return this;
        }
    }

    private static class SpecResolver
    implements SpecVisitor {
        private Endpoint endpoint;
        private final boolean discoverEnabled;
        private final Map<String, ShardedServiceDiscoveryInfo> serviceFinders;

        private SpecResolver(boolean discoverEnabled, Map<String, ShardedServiceDiscoveryInfo> serviceFinders) {
            this.discoverEnabled = discoverEnabled;
            this.serviceFinders = serviceFinders;
        }

        @Override
        public void visit(SimpleEndpointSpec simpleEndpointSpecification) {
            this.endpoint = Endpoint.builder().host(simpleEndpointSpecification.getHost()).port(simpleEndpointSpecification.getPort()).build();
        }

        @Override
        public void visit(RangerEndpointSpec rangerEndpointSpecification) {
            if (!this.discoverEnabled) {
                throw new IllegalAccessError("Zookeeper is not initialized in emissary YAML config. Discovery based lookups will not be possible.");
            }
            SimpleShardedServiceFinder<ShardInfo> finder = this.serviceFinders.get(rangerEndpointSpecification.getService()).getShardFinder();
            ServiceNode node = finder.get((Object)ShardInfo.builder().environment(rangerEndpointSpecification.getEnvironment()).build());
            this.endpoint = Endpoint.builder().host(node.getHost()).port(node.getPort()).build();
        }

        Endpoint resolve(EndpointSpec specification) {
            specification.accept(this);
            return this.endpoint;
        }
    }

    public static final class ShardInfo {
        private String environment;

        public static ShardInfoBuilder builder() {
            return new ShardInfoBuilder();
        }

        public String getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShardInfo)) {
                return false;
            }
            ShardInfo other = (ShardInfo)o;
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "RevolverServiceResolver.ShardInfo(environment=" + this.getEnvironment() + ")";
        }

        @ConstructorProperties(value={"environment"})
        public ShardInfo(String environment) {
            this.environment = environment;
        }

        public ShardInfo() {
        }

        public static class ShardInfoBuilder {
            private String environment;

            ShardInfoBuilder() {
            }

            public ShardInfoBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public ShardInfo build() {
                return new ShardInfo(this.environment);
            }

            public String toString() {
                return "RevolverServiceResolver.ShardInfo.ShardInfoBuilder(environment=" + this.environment + ")";
            }
        }
    }

    public static final class ShardedServiceDiscoveryInfo {
        private String environment;
        private SimpleShardedServiceFinder<ShardInfo> shardFinder;

        ShardedServiceDiscoveryInfo(String environment, SimpleShardedServiceFinder<ShardInfo> shardFinder) {
            this.environment = environment;
            this.shardFinder = shardFinder;
        }

        public static ShardedServiceDiscoveryInfoBuilder builder() {
            return new ShardedServiceDiscoveryInfoBuilder();
        }

        public String getEnvironment() {
            return this.environment;
        }

        public SimpleShardedServiceFinder<ShardInfo> getShardFinder() {
            return this.shardFinder;
        }

        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        public void setShardFinder(SimpleShardedServiceFinder<ShardInfo> shardFinder) {
            this.shardFinder = shardFinder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShardedServiceDiscoveryInfo)) {
                return false;
            }
            ShardedServiceDiscoveryInfo other = (ShardedServiceDiscoveryInfo)o;
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
                return false;
            }
            SimpleShardedServiceFinder<ShardInfo> this$shardFinder = this.getShardFinder();
            SimpleShardedServiceFinder<ShardInfo> other$shardFinder = other.getShardFinder();
            return !(this$shardFinder == null ? other$shardFinder != null : !this$shardFinder.equals(other$shardFinder));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            SimpleShardedServiceFinder<ShardInfo> $shardFinder = this.getShardFinder();
            result = result * 59 + ($shardFinder == null ? 43 : $shardFinder.hashCode());
            return result;
        }

        public String toString() {
            return "RevolverServiceResolver.ShardedServiceDiscoveryInfo(environment=" + this.getEnvironment() + ", shardFinder=" + this.getShardFinder() + ")";
        }

        public ShardedServiceDiscoveryInfo() {
        }

        public static class ShardedServiceDiscoveryInfoBuilder {
            private String environment;
            private SimpleShardedServiceFinder<ShardInfo> shardFinder;

            ShardedServiceDiscoveryInfoBuilder() {
            }

            public ShardedServiceDiscoveryInfoBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public ShardedServiceDiscoveryInfoBuilder shardFinder(SimpleShardedServiceFinder<ShardInfo> shardFinder) {
                this.shardFinder = shardFinder;
                return this;
            }

            public ShardedServiceDiscoveryInfo build() {
                return new ShardedServiceDiscoveryInfo(this.environment, this.shardFinder);
            }

            public String toString() {
                return "RevolverServiceResolver.ShardedServiceDiscoveryInfo.ShardedServiceDiscoveryInfoBuilder(environment=" + this.environment + ", shardFinder=" + this.shardFinder + ")";
            }
        }
    }
}

