/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.authorizer;

import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerRoleAuthorizer
implements PrimerAnnotationAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(PrimerRoleAuthorizer.class);

    @Override
    public boolean authorize(JsonWebToken jwt, ContainerRequestContext containerRequestContext, Authorize authorize) {
        List<String> authorizedRoles = Arrays.asList(authorize.value());
        if (authorizedRoles.contains(jwt.claim().getParameter("role"))) {
            return true;
        }
        return jwt.claim().getParameter("roles") != null && !Collections.disjoint(authorizedRoles, (List)jwt.claim().getParameter("roles"));
    }

    PrimerRoleAuthorizer() {
    }

    public static PrimerRoleAuthorizerBuilder builder() {
        return new PrimerRoleAuthorizerBuilder();
    }

    public static class PrimerRoleAuthorizerBuilder {
        PrimerRoleAuthorizerBuilder() {
        }

        public PrimerRoleAuthorizer build() {
            return new PrimerRoleAuthorizer();
        }

        public String toString() {
            return "PrimerRoleAuthorizer.PrimerRoleAuthorizerBuilder()";
        }
    }
}

