/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.primer.auth.annotation.PrimerAuth;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import io.dropwizard.primer.auth.filter.PrimerAuthAnnotationFilter;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

public class PrimerAuthAnnotationFeature
implements DynamicFeature {
    private final PrimerBundleConfiguration configuration;
    private final ObjectMapper mapper;
    private final PrimerAnnotationAuthorizer authorizer;

    public PrimerAuthAnnotationFeature(PrimerBundleConfiguration configuration, ObjectMapper mapper, PrimerAnnotationAuthorizer authorizer) {
        this.configuration = configuration;
        this.mapper = mapper;
        this.authorizer = authorizer;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod != null) {
            Stream.of(resourceMethod.getParameterAnnotations()).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(PrimerAuth.class)).map(PrimerAuth.class::cast).findFirst().ifPresent(primerAuth -> {
                FeatureContext cfr_ignored_0 = (FeatureContext)featureContext.register((Object)PrimerAuthAnnotationFilter.builder().primerAuth((PrimerAuth)primerAuth).authorizer(this.authorizer).build());
            });
        }
    }

    public static PrimerAuthAnnotationFeatureBuilder builder() {
        return new PrimerAuthAnnotationFeatureBuilder();
    }

    public static class PrimerAuthAnnotationFeatureBuilder {
        private PrimerBundleConfiguration configuration;
        private ObjectMapper mapper;
        private PrimerAnnotationAuthorizer authorizer;

        PrimerAuthAnnotationFeatureBuilder() {
        }

        public PrimerAuthAnnotationFeatureBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthAnnotationFeatureBuilder mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public PrimerAuthAnnotationFeatureBuilder authorizer(PrimerAnnotationAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public PrimerAuthAnnotationFeature build() {
            return new PrimerAuthAnnotationFeature(this.configuration, this.mapper, this.authorizer);
        }

        public String toString() {
            return "PrimerAuthAnnotationFeature.PrimerAuthAnnotationFeatureBuilder(configuration=" + this.configuration + ", mapper=" + this.mapper + ", authorizer=" + this.authorizer + ")";
        }
    }
}

