/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.filter;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.primer.auth.AuthFilter;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
@Singleton
public class PrimerAuthConfigFilter
extends AuthFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthConfigFilter.class);
    @Context
    private HttpServletRequest requestProxy;

    public PrimerAuthConfigFilter(PrimerBundleConfiguration configuration, ObjectMapper objectMapper) {
        super(AuthType.CONFIG, configuration, objectMapper);
    }

    @Metered(name="primer")
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.isEnabled() || this.isWhitelisted(requestContext)) {
            return;
        }
        Optional<String> token = this.getToken(requestContext);
        if (!token.isPresent()) {
            requestContext.abortWith(Response.status((Response.Status)this.configuration.getAbsentTokenStatus()).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build())).build());
        } else {
            try {
                JsonWebToken webToken = this.authorize(requestContext, token.get(), this.authType);
                this.stampHeaders(requestContext, webToken);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), requestContext, token.get());
                } else {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof PrimerException) {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
                this.handleException(e, requestContext, token.get());
            }
        }
    }

    private boolean isEnabled() {
        return this.configuration.isEnabled() && this.configuration.getAuthTypesEnabled().getOrDefault((Object)AuthType.CONFIG, false) != false;
    }

    private boolean isWhitelisted(ContainerRequestContext requestContext) {
        return PrimerAuthorizationRegistry.isWhilisted(requestContext.getUriInfo().getPath());
    }

    public static PrimerAuthConfigFilterBuilder builder() {
        return new PrimerAuthConfigFilterBuilder();
    }

    public static class PrimerAuthConfigFilterBuilder {
        private PrimerBundleConfiguration configuration;
        private ObjectMapper objectMapper;

        PrimerAuthConfigFilterBuilder() {
        }

        public PrimerAuthConfigFilterBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthConfigFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerAuthConfigFilter build() {
            return new PrimerAuthConfigFilter(this.configuration, this.objectMapper);
        }

        public String toString() {
            return "PrimerAuthConfigFilter.PrimerAuthConfigFilterBuilder(configuration=" + this.configuration + ", objectMapper=" + this.objectMapper + ")";
        }
    }
}

