/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.whitelist;

import io.dropwizard.primer.auth.annotation.AuthWhitelist;
import io.dropwizard.primer.auth.whitelist.WhitelistType;
import io.dropwizard.primer.util.IPAddressUtil;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AuthWhitelistValidator
implements WhitelistType.Visitor<Boolean> {
    private final AuthWhitelist authWhitelist;
    private final HttpServletRequest requestProxy;

    public AuthWhitelistValidator(AuthWhitelist authWhitelist, HttpServletRequest requestProxy) {
        this.authWhitelist = authWhitelist;
        this.requestProxy = requestProxy;
    }

    @Override
    public Boolean visitOptional() {
        return Boolean.parseBoolean(this.authWhitelist.value()) && StringUtils.isNotBlank((CharSequence)this.requestProxy.getHeader("Authorization"));
    }

    @Override
    public Boolean visitIP() {
        return Arrays.asList(this.authWhitelist.value().split(",")).contains(IPAddressUtil.getIP(this.requestProxy));
    }

    public static AuthWhitelistValidatorBuilder builder() {
        return new AuthWhitelistValidatorBuilder();
    }

    public static class AuthWhitelistValidatorBuilder {
        private AuthWhitelist authWhitelist;
        private HttpServletRequest requestProxy;

        AuthWhitelistValidatorBuilder() {
        }

        public AuthWhitelistValidatorBuilder authWhitelist(AuthWhitelist authWhitelist) {
            this.authWhitelist = authWhitelist;
            return this;
        }

        public AuthWhitelistValidatorBuilder requestProxy(HttpServletRequest requestProxy) {
            this.requestProxy = requestProxy;
            return this;
        }

        public AuthWhitelistValidator build() {
            return new AuthWhitelistValidator(this.authWhitelist, this.requestProxy);
        }

        public String toString() {
            return "AuthWhitelistValidator.AuthWhitelistValidatorBuilder(authWhitelist=" + this.authWhitelist + ", requestProxy=" + this.requestProxy + ")";
        }
    }
}

