/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import io.dropwizard.primer.PrimerBundle;
import io.dropwizard.primer.cache.TokenCacheManager;
import io.dropwizard.primer.core.ServiceUser;
import io.dropwizard.primer.core.VerifyResponse;
import io.dropwizard.primer.core.VerifyStaticResponse;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerAuthorization;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerAuthorizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthorizationRegistry.class);
    private static ImmutableMap<String, String> urlIndex;
    private static ImmutableMap<String, PrimerAuthorization> authList;
    private static ImmutableSet<String> whiteList;

    public static void init(PrimerAuthorizationMatrix matrix, Set<String> whiteListUrls) {
        ImmutableMap.Builder authListBuilder = ImmutableMap.builder();
        ImmutableMap.Builder urlIndexBuilder = ImmutableMap.builder();
        if (matrix != null) {
            matrix.getAuthorizations().forEach(auth -> {
                String indexId = Hashing.murmur3_128().hashString((CharSequence)auth.getUrl(), Charsets.UTF_8).toString();
                urlIndexBuilder.put((Object)indexId, (Object)PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl()));
                authListBuilder.put((Object)indexId, auth);
            });
        }
        authList = authListBuilder.build();
        urlIndex = urlIndexBuilder.build();
        ImmutableSet.Builder whiteListBuilder = ImmutableSet.builder();
        whiteListUrls.forEach(p -> whiteListBuilder.add((Object)PrimerAuthorizationRegistry.generatePathExpression(p)));
        whiteList = whiteListBuilder.build();
    }

    private static String generatePathExpression(String path) {
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    public static boolean authorize(String path, String role, String method, String token, JsonWebToken jsonWebToken) throws PrimerException {
        Optional<Map.Entry> index = urlIndex.entrySet().stream().filter(e -> path.matches((String)e.getValue())).findFirst();
        if (!index.isPresent()) {
            return false;
        }
        if (!PrimerAuthorizationRegistry.isAuthorized((String)index.get().getKey(), method, role)) {
            return false;
        }
        if (TokenCacheManager.checkCache(token)) {
            return true;
        }
        switch (((PrimerAuthorization)authList.get(index.get().getKey())).getType()) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verify(jsonWebToken, token);
            }
            case "static": {
                return PrimerAuthorizationRegistry.verifyStatic(jsonWebToken, token);
            }
        }
        return false;
    }

    public static boolean isWhilisted(String path) {
        return whiteList.stream().filter(path::matches).findFirst().isPresent();
    }

    private static boolean isAuthorized(String id, String method, String role) {
        return ((PrimerAuthorization)authList.get((Object)id)).getRoles().contains(role) && ((PrimerAuthorization)authList.get((Object)id)).getMethods().contains(method);
    }

    private static boolean verify(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyResponse verifyResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, ServiceUser.builder().id((String)webToken.claim().getParameter("user_id")).name((String)webToken.claim().getParameter("name")).role((String)webToken.claim().getParameter("role")).build());
        boolean bl = result = !StringUtils.isBlank((CharSequence)verifyResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyResponse.getUserId());
        if (result) {
            TokenCacheManager.cache(token);
        }
        return result;
    }

    private static boolean verifyStatic(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyStaticResponse verifyStaticResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, (String)webToken.claim().getParameter("role"));
        boolean bl = result = !StringUtils.isBlank((CharSequence)verifyStaticResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyStaticResponse.getId());
        if (result) {
            TokenCacheManager.cache(token);
        }
        return result;
    }
}

