/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuava;
import com.google.common.cache.LoadingCache;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCacheManager {
    private static final Logger log = LoggerFactory.getLogger(TokenCacheManager.class);
    private static LoadingCache<String, Optional<Boolean>> blacklistCache;
    private static LoadingCache<String, Optional<Boolean>> lruCache;

    public static void init(PrimerBundleConfiguration configuration) {
        blacklistCache = CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()), s -> Optional.of(false));
        lruCache = CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()), s -> Optional.of(false));
    }

    public static void blackList(String token) {
        blacklistCache.put((Object)token, Optional.of(true));
    }

    public static void cache(String token) {
        lruCache.put((Object)token, Optional.of(true));
    }

    public static boolean checkCache(String token) {
        try {
            Optional result = (Optional)lruCache.get((Object)token);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static boolean checkBlackList(String token) throws ExecutionException {
        return (Boolean)((Optional)blacklistCache.get((Object)token)).get();
    }
}

