/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.InvalidSignatureException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.MalformedJsonWebTokenException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenExpiredException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.UncheckedExecutionException;
import feign.FeignException;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
@Singleton
public class PrimerAuthenticatorRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthenticatorRequestFilter.class);
    private PrimerBundleConfiguration configuration;
    private ObjectMapper objectMapper;
    private static final String AUTHORIZED_FOR_ID = "X-AUTHORIZED-FOR-ID";
    private static final String AUTHORIZED_FOR_SUBJECT = "X-AUTHORIZED-FOR-SUBJECT";
    private static final String AUTHORIZED_FOR_NAME = "X-AUTHORIZED-FOR-NAME";

    public PrimerAuthenticatorRequestFilter(PrimerBundleConfiguration configuration, ObjectMapper objectMapper) {
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }

    @Metered(name="primer")
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.configuration.isEnabled()) {
            return;
        }
        if (PrimerAuthorizationRegistry.isWhilisted(requestContext.getUriInfo().getPath())) {
            return;
        }
        Optional<String> token = this.getToken(requestContext);
        if (!token.isPresent()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build())).build());
        } else {
            try {
                JsonWebToken webToken = this.authorize(requestContext, token.get());
                this.stampHeaders(requestContext, webToken);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), requestContext, token.get());
                } else {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
            }
            catch (Exception e) {
                log.error("Execution error: {}", (Object)e.getMessage());
                this.handleError(Response.Status.INTERNAL_SERVER_ERROR, "PR000", "Error", token.get(), requestContext);
            }
        }
    }

    private JsonWebToken authorize(ContainerRequestContext requestContext, String token) throws ExecutionException {
        return PrimerAuthorizationRegistry.authorize(requestContext.getUriInfo().getPath(), requestContext.getMethod(), token);
    }

    private Optional<String> getToken(ContainerRequestContext requestContext) {
        String header = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        log.debug("Authorization Header: {}", (Object)header);
        if (header != null) {
            String rawToken = header.replaceAll(this.configuration.getPrefix(), "").trim();
            if (Strings.isNullOrEmpty((String)rawToken)) {
                return Optional.empty();
            }
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    private void stampHeaders(ContainerRequestContext requestContext, JsonWebToken webToken) {
        String tokenType;
        switch (tokenType = (String)webToken.claim().getParameter("type")) {
            case "dynamic": {
                requestContext.getHeaders().putSingle((Object)AUTHORIZED_FOR_ID, (Object)((String)webToken.claim().getParameter("user_id")));
                requestContext.getHeaders().putSingle((Object)AUTHORIZED_FOR_SUBJECT, (Object)webToken.claim().subject());
                requestContext.getHeaders().putSingle((Object)AUTHORIZED_FOR_NAME, (Object)((String)webToken.claim().getParameter("name")));
                break;
            }
            case "static": {
                requestContext.getHeaders().putSingle((Object)AUTHORIZED_FOR_SUBJECT, (Object)webToken.claim().subject());
                break;
            }
            default: {
                log.warn("No auth header stamped for type: {}", (Object)tokenType);
            }
        }
    }

    private void handleException(Throwable e, ContainerRequestContext requestContext, String token) throws JsonProcessingException {
        if (e.getCause() instanceof TokenExpiredException || e instanceof TokenExpiredException) {
            log.error("Token Expiry Error: {}", (Object)e.getMessage());
            requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR003").message("Expired").build())).build());
        } else if (e.getCause() instanceof MalformedJsonWebTokenException || e instanceof MalformedJsonWebTokenException) {
            log.error("Token Malformed Error: {}", (Object)e.getMessage());
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR004").message("Unauthorized").build())).build());
        } else if (e.getCause() instanceof InvalidSignatureException || e instanceof InvalidSignatureException) {
            log.error("Token Signature Error: {}", (Object)e.getMessage());
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR004").message("Unauthorized").build())).build());
        } else if (e.getCause() instanceof FeignException) {
            log.error("Feign error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((FeignException)e.getCause()).status()), "PR000", e.getCause().getMessage(), token, requestContext);
        } else if (e instanceof FeignException) {
            log.error("Feign error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((FeignException)e).status()), "PR000", e.getMessage(), token, requestContext);
        } else if (e.getCause() instanceof PrimerException) {
            log.error("Primer error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((PrimerException)e.getCause()).getStatus()), ((PrimerException)e.getCause()).getErrorCode(), e.getCause().getMessage(), token, requestContext);
        } else if (e instanceof PrimerException) {
            log.error("Primer error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((PrimerException)e).getStatus()), ((PrimerException)e).getErrorCode(), e.getMessage(), token, requestContext);
        } else {
            log.error("General error: {}", e);
            this.handleError(Response.Status.INTERNAL_SERVER_ERROR, "PR000", "Error", token, requestContext);
        }
    }

    private void handleError(Response.Status status, String errorCode, String message, String token, ContainerRequestContext requestContext) throws JsonProcessingException {
        switch (status) {
            case NOT_FOUND: 
            case UNAUTHORIZED: {
                PrimerAuthorizationRegistry.blacklist(token);
                requestContext.abortWith(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR004").message("Unauthorized").build())).build());
                break;
            }
            case FORBIDDEN: {
                PrimerAuthorizationRegistry.blacklist(token);
                requestContext.abortWith(Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR002").message("Forbidden").build())).build());
                break;
            }
            default: {
                requestContext.abortWith(Response.status((Response.Status)status).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode(errorCode).message(message).build())).build());
            }
        }
    }

    public static PrimerAuthenticatorRequestFilterBuilder builder() {
        return new PrimerAuthenticatorRequestFilterBuilder();
    }

    public static class PrimerAuthenticatorRequestFilterBuilder {
        private PrimerBundleConfiguration configuration;
        private ObjectMapper objectMapper;

        PrimerAuthenticatorRequestFilterBuilder() {
        }

        public PrimerAuthenticatorRequestFilterBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthenticatorRequestFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerAuthenticatorRequestFilter build() {
            return new PrimerAuthenticatorRequestFilter(this.configuration, this.objectMapper);
        }

        public String toString() {
            return "PrimerAuthenticatorRequestFilter.PrimerAuthenticatorRequestFilterBuilder(configuration=" + this.configuration + ", objectMapper=" + this.objectMapper + ")";
        }
    }
}

