/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuava;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenExpiredException;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.cache.LoadingCache;
import io.dropwizard.primer.PrimerBundle;
import io.dropwizard.primer.auth.TokenKey;
import io.dropwizard.primer.core.ServiceUser;
import io.dropwizard.primer.core.VerifyResponse;
import io.dropwizard.primer.core.VerifyStaticResponse;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerAuthorization;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerAuthorizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthorizationRegistry.class);
    private static Map<String, PrimerAuthorization> authList;
    private static List<String> whiteList;
    private static List<String> urlPatterns;
    private static LoadingCache<String, Optional<Boolean>> blacklistCache;
    private static LoadingCache<TokenKey, JsonWebToken> lruCache;
    private static Duration acceptableClockSkew;
    private static JsonWebTokenParser parser;
    private static HmacSHA512Verifier verifier;

    public static void init(PrimerAuthorizationMatrix matrix, Set<String> whiteListUrls, PrimerBundleConfiguration configuration, JsonWebTokenParser tokenParser, HmacSHA512Verifier tokenVerifier) {
        authList = new HashMap<String, PrimerAuthorization>();
        whiteList = new ArrayList<String>();
        urlPatterns = new ArrayList<String>();
        parser = tokenParser;
        verifier = tokenVerifier;
        HashMap urlToAuthMap = new HashMap();
        Pattern tokenMatch = Pattern.compile("\\{(([^/])+\\})");
        if (matrix != null) {
            matrix.getAuthorizations().forEach(auth -> {
                String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                urlPatterns.add(pattern);
                urlToAuthMap.put(pattern, auth);
            });
            matrix.getStaticAuthorizations().forEach(auth -> {
                String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                urlPatterns.add(pattern);
                urlToAuthMap.put(pattern, auth);
            });
            matrix.getAutoAuthorizations().forEach(auth -> {
                String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                urlPatterns.add(pattern);
                urlToAuthMap.put(pattern, auth);
            });
            Collections.sort(urlPatterns, (o1, o2) -> tokenMatch.matcher((CharSequence)o2).groupCount() - tokenMatch.matcher((CharSequence)o1).groupCount());
            Collections.sort(urlPatterns, (o1, o2) -> o2.compareTo((String)o1));
            urlPatterns.forEach(pattern -> authList.put((String)pattern, (PrimerAuthorization)urlToAuthMap.get(pattern)));
        }
        whiteListUrls.forEach(url -> whiteList.add(PrimerAuthorizationRegistry.generatePathExpression(url)));
        Collections.sort(whiteList, (o1, o2) -> tokenMatch.matcher((CharSequence)o2).groupCount() - tokenMatch.matcher((CharSequence)o1).groupCount());
        Collections.sort(whiteList, (o1, o2) -> o2.compareTo((String)o1));
        acceptableClockSkew = new Duration((long)configuration.getClockSkew());
        blacklistCache = CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()), s -> Optional.of(false));
        lruCache = CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()), PrimerAuthorizationRegistry::verifyToken);
    }

    private static String generatePathExpression(String path) {
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    public static JsonWebToken authorize(String path, String method, String token) throws ExecutionException {
        return (JsonWebToken)lruCache.get((Object)TokenKey.builder().method(method).path(path).token(token).build());
    }

    public static boolean isWhilisted(String path) {
        return whiteList.stream().filter(path::matches).findFirst().isPresent();
    }

    private static boolean isAuthorized(String id, String method, String role) {
        return authList.get(id).getRoles().contains(role) && authList.get(id).getMethods().contains(method);
    }

    private static JsonWebToken verify(JsonWebToken webToken, String token, String type) throws PrimerException {
        switch (type) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verify(webToken, token);
            }
            case "static": {
                return PrimerAuthorizationRegistry.verifyStatic(webToken, token);
            }
        }
        throw PrimerException.builder().errorCode("PR002").message("Unauthorized").status(401).build();
    }

    private static JsonWebToken verify(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyResponse verifyResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, ServiceUser.builder().id((String)webToken.claim().getParameter("user_id")).name((String)webToken.claim().getParameter("name")).role((String)webToken.claim().getParameter("role")).build());
        boolean bl = result = !StringUtils.isBlank((CharSequence)verifyResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyResponse.getUserId());
        if (!result) {
            PrimerAuthorizationRegistry.blacklist(token);
            throw PrimerException.builder().errorCode("PR002").message("Unauthorized").status(401).build();
        }
        return webToken;
    }

    private static JsonWebToken verifyStatic(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyStaticResponse verifyStaticResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, (String)webToken.claim().getParameter("role"));
        boolean bl = result = !StringUtils.isBlank((CharSequence)verifyStaticResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyStaticResponse.getId());
        if (!result) {
            PrimerAuthorizationRegistry.blacklist(token);
            throw PrimerException.builder().errorCode("PR002").message("Unauthorized").status(401).build();
        }
        return webToken;
    }

    private static void checkExpiry(JsonWebToken token) {
        if (token.claim() != null) {
            Instant now = new Instant();
            Instant issuedAt = (Instant)com.google.common.base.Optional.fromNullable((Object)PrimerAuthorizationRegistry.toInstant(token.claim().issuedAt())).or((Object)now);
            Instant expiration = (Instant)com.google.common.base.Optional.fromNullable((Object)PrimerAuthorizationRegistry.toInstant(token.claim().expiration())).or((Object)new Instant(Long.MAX_VALUE));
            Instant notBefore = (Instant)com.google.common.base.Optional.fromNullable((Object)PrimerAuthorizationRegistry.toInstant(token.claim().notBefore())).or((Object)now);
            if (issuedAt.isAfter((ReadableInstant)expiration) || notBefore.isAfterNow() || !PrimerAuthorizationRegistry.inInterval(issuedAt, expiration, now)) {
                throw new TokenExpiredException();
            }
        }
    }

    private static JsonWebToken verifyToken(TokenKey tokenKey) throws PrimerException {
        JsonWebToken webToken = parser.parse(tokenKey.getToken());
        verifier.verifySignature(webToken);
        PrimerAuthorizationRegistry.checkExpiry(webToken);
        String role = (String)webToken.claim().getParameter("role");
        Optional<String> index = urlPatterns.stream().filter(tokenKey.getPath()::matches).findFirst();
        if (!index.isPresent()) {
            throw PrimerException.builder().errorCode("PR001").message("Unauthorized").status(401).build();
        }
        if (!PrimerAuthorizationRegistry.isAuthorized(index.get(), tokenKey.getMethod(), role)) {
            throw PrimerException.builder().errorCode("PR001").message("Unauthorized").status(401).build();
        }
        switch (authList.get(index.get()).getType()) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), "dynamic");
            }
            case "static": {
                return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), "static");
            }
            case "auto": {
                String type = (String)webToken.claim().getParameter("type");
                return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), type);
            }
        }
        throw PrimerException.builder().errorCode("PR001").message("Unauthorized").status(401).build();
    }

    private static boolean inInterval(Instant start, Instant end, Instant now) {
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        Interval currentTimeWithSkew = new Interval((ReadableInstant)now.minus((ReadableDuration)acceptableClockSkew), (ReadableInstant)now.plus((ReadableDuration)acceptableClockSkew));
        return interval.overlaps((ReadableInterval)currentTimeWithSkew);
    }

    private static Instant toInstant(Long input) {
        if (input == null) {
            return null;
        }
        return new Instant(input * 1000L);
    }

    public static void blacklist(String token) {
        blacklistCache.put((Object)token, Optional.of(true));
    }
}

