/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.model;

import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerEndpoint;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;

public class PrimerBundleConfiguration {
    @Valid
    private PrimerEndpoint endpoint;
    private int cacheExpiry;
    private int cacheMaxSize;
    private int clockSkew;
    private String prefix;
    private String privateKey;
    private boolean enabled = true;
    private Set<String> whileListUrl = new HashSet<String>();
    private PrimerAuthorizationMatrix authorizations;

    public static PrimerBundleConfigurationBuilder builder() {
        return new PrimerBundleConfigurationBuilder();
    }

    public PrimerEndpoint getEndpoint() {
        return this.endpoint;
    }

    public int getCacheExpiry() {
        return this.cacheExpiry;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public int getClockSkew() {
        return this.clockSkew;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getWhileListUrl() {
        return this.whileListUrl;
    }

    public PrimerAuthorizationMatrix getAuthorizations() {
        return this.authorizations;
    }

    public void setEndpoint(PrimerEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setCacheExpiry(int cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setClockSkew(int clockSkew) {
        this.clockSkew = clockSkew;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setWhileListUrl(Set<String> whileListUrl) {
        this.whileListUrl = whileListUrl;
    }

    public void setAuthorizations(PrimerAuthorizationMatrix authorizations) {
        this.authorizations = authorizations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimerBundleConfiguration)) {
            return false;
        }
        PrimerBundleConfiguration other = (PrimerBundleConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PrimerEndpoint this$endpoint = this.getEndpoint();
        PrimerEndpoint other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        if (this.getCacheExpiry() != other.getCacheExpiry()) {
            return false;
        }
        if (this.getCacheMaxSize() != other.getCacheMaxSize()) {
            return false;
        }
        if (this.getClockSkew() != other.getClockSkew()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Set<String> this$whileListUrl = this.getWhileListUrl();
        Set<String> other$whileListUrl = other.getWhileListUrl();
        if (this$whileListUrl == null ? other$whileListUrl != null : !((Object)this$whileListUrl).equals(other$whileListUrl)) {
            return false;
        }
        PrimerAuthorizationMatrix this$authorizations = this.getAuthorizations();
        PrimerAuthorizationMatrix other$authorizations = other.getAuthorizations();
        return !(this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrimerBundleConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrimerEndpoint $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        result = result * 59 + this.getCacheExpiry();
        result = result * 59 + this.getCacheMaxSize();
        result = result * 59 + this.getClockSkew();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Set<String> $whileListUrl = this.getWhileListUrl();
        result = result * 59 + ($whileListUrl == null ? 43 : ((Object)$whileListUrl).hashCode());
        PrimerAuthorizationMatrix $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        return result;
    }

    public String toString() {
        return "PrimerBundleConfiguration(endpoint=" + this.getEndpoint() + ", cacheExpiry=" + this.getCacheExpiry() + ", cacheMaxSize=" + this.getCacheMaxSize() + ", clockSkew=" + this.getClockSkew() + ", prefix=" + this.getPrefix() + ", privateKey=" + this.getPrivateKey() + ", enabled=" + this.isEnabled() + ", whileListUrl=" + this.getWhileListUrl() + ", authorizations=" + this.getAuthorizations() + ")";
    }

    @ConstructorProperties(value={"endpoint", "cacheExpiry", "cacheMaxSize", "clockSkew", "prefix", "privateKey", "enabled", "whileListUrl", "authorizations"})
    public PrimerBundleConfiguration(PrimerEndpoint endpoint, int cacheExpiry, int cacheMaxSize, int clockSkew, String prefix, String privateKey, boolean enabled, Set<String> whileListUrl, PrimerAuthorizationMatrix authorizations) {
        this.endpoint = endpoint;
        this.cacheExpiry = cacheExpiry;
        this.cacheMaxSize = cacheMaxSize;
        this.clockSkew = clockSkew;
        this.prefix = prefix;
        this.privateKey = privateKey;
        this.enabled = enabled;
        this.whileListUrl = whileListUrl;
        this.authorizations = authorizations;
    }

    public PrimerBundleConfiguration() {
    }

    public static class PrimerBundleConfigurationBuilder {
        private PrimerEndpoint endpoint;
        private int cacheExpiry;
        private int cacheMaxSize;
        private int clockSkew;
        private String prefix;
        private String privateKey;
        private boolean enabled;
        private ArrayList<String> whileListUrl;
        private PrimerAuthorizationMatrix authorizations;

        PrimerBundleConfigurationBuilder() {
        }

        public PrimerBundleConfigurationBuilder endpoint(PrimerEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public PrimerBundleConfigurationBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry = cacheExpiry;
            return this;
        }

        public PrimerBundleConfigurationBuilder cacheMaxSize(int cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public PrimerBundleConfigurationBuilder clockSkew(int clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public PrimerBundleConfigurationBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public PrimerBundleConfigurationBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public PrimerBundleConfigurationBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PrimerBundleConfigurationBuilder whiteList(String whiteList) {
            if (this.whileListUrl == null) {
                this.whileListUrl = new ArrayList();
            }
            this.whileListUrl.add(whiteList);
            return this;
        }

        public PrimerBundleConfigurationBuilder whileListUrl(Collection<? extends String> whileListUrl) {
            if (this.whileListUrl == null) {
                this.whileListUrl = new ArrayList();
            }
            this.whileListUrl.addAll(whileListUrl);
            return this;
        }

        public PrimerBundleConfigurationBuilder clearWhileListUrl() {
            if (this.whileListUrl != null) {
                this.whileListUrl.clear();
            }
            return this;
        }

        public PrimerBundleConfigurationBuilder authorizations(PrimerAuthorizationMatrix authorizations) {
            this.authorizations = authorizations;
            return this;
        }

        public PrimerBundleConfiguration build() {
            Set<Object> whileListUrl;
            switch (this.whileListUrl == null ? 0 : this.whileListUrl.size()) {
                case 0: {
                    whileListUrl = Collections.emptySet();
                    break;
                }
                case 1: {
                    whileListUrl = Collections.singleton(this.whileListUrl.get(0));
                    break;
                }
                default: {
                    whileListUrl = new LinkedHashSet(this.whileListUrl.size() < 0x40000000 ? 1 + this.whileListUrl.size() + (this.whileListUrl.size() - 3) / 3 : Integer.MAX_VALUE);
                    whileListUrl.addAll(this.whileListUrl);
                    whileListUrl = Collections.unmodifiableSet(whileListUrl);
                }
            }
            return new PrimerBundleConfiguration(this.endpoint, this.cacheExpiry, this.cacheMaxSize, this.clockSkew, this.prefix, this.privateKey, this.enabled, whileListUrl, this.authorizations);
        }

        public String toString() {
            return "PrimerBundleConfiguration.PrimerBundleConfigurationBuilder(endpoint=" + this.endpoint + ", cacheExpiry=" + this.cacheExpiry + ", cacheMaxSize=" + this.cacheMaxSize + ", clockSkew=" + this.clockSkew + ", prefix=" + this.prefix + ", privateKey=" + this.privateKey + ", enabled=" + this.enabled + ", whileListUrl=" + this.whileListUrl + ", authorizations=" + this.authorizations + ")";
        }
    }
}

