/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import io.dropwizard.maxmind.geoip2.config.MaxMindConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
public class MaxMindGeoIpRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MaxMindGeoIpRequestFilter.class);
    private final MaxMindConfig config;
    private DatabaseReader databaseReader;

    public MaxMindGeoIpRequestFilter(final MaxMindConfig config) {
        this.config = config;
        try {
            this.databaseReader = new DatabaseReader.Builder(new File(config.getDatabaseFilePath())).withCache(new NodeCache(){
                private Cache<Integer, JsonNode> cache;
                {
                    this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)config.getCacheMaxEntries()).recordStats().build();
                }

                public JsonNode get(int i, NodeCache.Loader loader) throws IOException {
                    try {
                        return (JsonNode)this.cache.get((Object)i, () -> loader.load(i));
                    }
                    catch (ExecutionException e) {
                        return null;
                    }
                }
            }).build();
        }
        catch (IOException e) {
            log.error("Error initializing GeoIP database", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        String clientAddress = (String)containerRequestContext.getHeaders().getFirst((Object)this.config.getRemoteIpHeader());
        if (Strings.isNullOrEmpty((String)clientAddress)) {
            return;
        }
        String[] addresses = clientAddress.split(",");
        String clientIp = addresses[0].split(":")[0];
        if (!Strings.isNullOrEmpty((String)clientIp)) {
            InetAddress address;
            try {
                address = InetAddress.getByName(clientIp);
            }
            catch (Exception e) {
                log.warn("Cannot resolve address: {} | Error: {}", (Object)clientIp, (Object)e.getMessage());
                return;
            }
            if (address == null) {
                log.warn("Cannot resolve address: {}", (Object)clientIp);
                return;
            }
            try {
                if (this.config.isEnterprise()) {
                    AnonymousIpResponse anonymousIpResponse;
                    EnterpriseResponse enterpriseResponse = this.databaseReader.enterprise(address);
                    if (enterpriseResponse == null) {
                        return;
                    }
                    if (enterpriseResponse.getCountry() != null) {
                        this.addCountryInfo(enterpriseResponse.getCountry(), containerRequestContext);
                    }
                    if (enterpriseResponse.getMostSpecificSubdivision() != null) {
                        this.addStateInfo(enterpriseResponse.getMostSpecificSubdivision(), containerRequestContext);
                    }
                    if (enterpriseResponse.getCity() != null) {
                        this.addCityInfo(enterpriseResponse.getCity(), containerRequestContext);
                    }
                    if (enterpriseResponse.getPostal() != null) {
                        this.addPostalInfo(enterpriseResponse.getPostal(), containerRequestContext);
                    }
                    if (enterpriseResponse.getLocation() != null) {
                        this.addLocationInfo(enterpriseResponse.getLocation(), containerRequestContext);
                    }
                    if (enterpriseResponse.getTraits() != null) {
                        this.addTraitsInfo(enterpriseResponse.getTraits(), containerRequestContext);
                    }
                    if ((anonymousIpResponse = this.databaseReader.anonymousIp(address)) != null) {
                        this.anonymousInfo(anonymousIpResponse, containerRequestContext);
                    }
                } else {
                    switch (this.config.getType()) {
                        case "country": {
                            CountryResponse countryResponse = this.databaseReader.country(address);
                            if (countryResponse == null || countryResponse.getCountry() == null) break;
                            this.addCountryInfo(countryResponse.getCountry(), containerRequestContext);
                            break;
                        }
                        case "city": {
                            CityResponse cityResponse = this.databaseReader.city(address);
                            if (cityResponse == null) break;
                            if (cityResponse.getMostSpecificSubdivision() != null) {
                                this.addStateInfo(cityResponse.getMostSpecificSubdivision(), containerRequestContext);
                            }
                            if (cityResponse.getCity() != null) {
                                this.addCityInfo(cityResponse.getCity(), containerRequestContext);
                            }
                            if (cityResponse.getPostal() != null) {
                                this.addPostalInfo(cityResponse.getPostal(), containerRequestContext);
                            }
                            if (cityResponse.getLocation() == null) break;
                            this.addLocationInfo(cityResponse.getLocation(), containerRequestContext);
                            break;
                        }
                        case "anonymous": {
                            AnonymousIpResponse anonymousIpResponse = this.databaseReader.anonymousIp(address);
                            if (anonymousIpResponse == null) break;
                            this.anonymousInfo(anonymousIpResponse, containerRequestContext);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("GeoIP Error: {}", (Object)e.getMessage());
            }
        }
    }

    private void addCountryInfo(Country country, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)country.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-COUNTRY", (Object)country.getName());
        }
    }

    private void addStateInfo(Subdivision subdivision, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)subdivision.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-STATE", (Object)subdivision.getName());
        }
    }

    private void addCityInfo(City city, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)city.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-CITY", (Object)city.getName());
        }
    }

    private void addPostalInfo(Postal postal, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)postal.getCode())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-POSTAL-CODE", (Object)postal.getCode());
        }
    }

    private void addLocationInfo(Location location, ContainerRequestContext containerRequestContext) {
        if (location.getLatitude() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LATITUDE", (Object)String.valueOf(location.getLatitude()));
        }
        if (location.getLongitude() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LONGITUDE", (Object)String.valueOf(location.getLongitude()));
        }
        if (location.getAccuracyRadius() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LOCATION-ACCURACY", (Object)String.valueOf(location.getAccuracyRadius()));
        }
    }

    private void addTraitsInfo(Traits traits, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)traits.getUserType())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-USER-TYPE", (Object)traits.getUserType());
        }
        if (Strings.isNullOrEmpty((String)traits.getIsp())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ISP", (Object)traits.getIsp());
        }
        if (traits.getConnectionType() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-CONNECTION-TYPE", (Object)traits.getConnectionType().name());
        }
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LEGAL-PROXY", (Object)String.valueOf(traits.isLegitimateProxy()));
    }

    private void anonymousInfo(AnonymousIpResponse anonymousIpResponse, ContainerRequestContext containerRequestContext) {
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ANONYMOUS-IP", (Object)String.valueOf(anonymousIpResponse.isAnonymous()));
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ANONYMOUS-VPN", (Object)String.valueOf(anonymousIpResponse.isAnonymousVpn()));
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-TOR-NODE", (Object)String.valueOf(anonymousIpResponse.isTorExitNode()));
    }
}

