/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceProviderBuilders;
import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.healthservice.monitor.IsolatedHealthMonitor;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import com.flipkart.ranger.serviceprovider.ServiceProviderBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.discovery.bundle.InfoResource;
import io.dropwizard.discovery.bundle.ServiceDiscoveryConfiguration;
import io.dropwizard.discovery.bundle.id.IdGenerator;
import io.dropwizard.discovery.bundle.id.NodeIdManager;
import io.dropwizard.discovery.bundle.id.constraints.IdValidationConstraint;
import io.dropwizard.discovery.bundle.rotationstatus.BIRTask;
import io.dropwizard.discovery.bundle.rotationstatus.OORTask;
import io.dropwizard.discovery.bundle.rotationstatus.RotationStatus;
import io.dropwizard.discovery.client.io.dropwizard.ranger.ServiceDiscoveryClient;
import io.dropwizard.discovery.common.ShardInfo;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceDiscoveryBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryBundle.class);
    private ServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    private List<Healthcheck> healthchecks = Lists.newArrayList();
    private ServiceProvider<ShardInfo> serviceProvider;
    private final List<IdValidationConstraint> globalIdConstraints;
    private CuratorFramework curator;
    private ServiceDiscoveryClient serviceDiscoveryClient;
    @VisibleForTesting
    private RotationStatus rotationStatus;

    protected ServiceDiscoveryBundle() {
        this.globalIdConstraints = Collections.emptyList();
    }

    protected ServiceDiscoveryBundle(List<IdValidationConstraint> globalIdConstraints) {
        this.globalIdConstraints = globalIdConstraints != null ? globalIdConstraints : Collections.emptyList();
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.serviceDiscoveryConfiguration = this.getRangerConfiguration(configuration);
        ObjectMapper objectMapper = environment.getObjectMapper();
        String namespace = this.serviceDiscoveryConfiguration.getNamespace();
        final String serviceName = this.getServiceName(configuration);
        String hostname = this.getHost();
        int port = this.getPort(configuration);
        long validdRegistationTime = System.currentTimeMillis() + this.serviceDiscoveryConfiguration.getInitialDelaySeconds() * 1000L;
        this.rotationStatus = new RotationStatus(this.serviceDiscoveryConfiguration.isInitialRotationStatus());
        this.curator = CuratorFrameworkFactory.builder().connectString(this.serviceDiscoveryConfiguration.getZookeeper()).namespace(namespace).retryPolicy((RetryPolicy)new RetryForever(this.serviceDiscoveryConfiguration.getConnectionRetryIntervalMillis())).build();
        ServiceProviderBuilder serviceProviderBuilder = ServiceProviderBuilders.shardedServiceProviderBuilder().withCuratorFramework(this.curator).withNamespace(namespace).withServiceName(serviceName).withSerializer(data -> {
            try {
                return objectMapper.writeValueAsBytes((Object)data);
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withHostname(hostname).withPort(port).withNodeData((Object)ShardInfo.builder().environment(this.serviceDiscoveryConfiguration.getEnvironment()).build()).withHealthcheck(() -> {
            for (Healthcheck healthcheck : this.healthchecks) {
                if (HealthcheckStatus.unhealthy != healthcheck.check()) continue;
                return HealthcheckStatus.unhealthy;
            }
            return HealthcheckStatus.healthy;
        }).withHealthcheck(() -> this.rotationStatus.status() ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy).withHealthcheck(() -> System.currentTimeMillis() > validdRegistationTime ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy);
        List<IsolatedHealthMonitor> healthMonitors = this.getHealthMonitors();
        if (healthMonitors != null && !healthMonitors.isEmpty()) {
            healthMonitors.forEach(arg_0 -> ((ServiceProviderBuilder)serviceProviderBuilder).withIsolatedHealthMonitor(arg_0));
        }
        this.serviceProvider = serviceProviderBuilder.buildServiceDiscovery();
        this.serviceDiscoveryClient = ServiceDiscoveryClient.fromCurator().curator(this.curator).namespace(namespace).serviceName(serviceName).environment(this.serviceDiscoveryConfiguration.getEnvironment()).objectMapper(environment.getObjectMapper()).build();
        environment.lifecycle().manage(new Managed(){

            public void start() throws Exception {
                ServiceDiscoveryBundle.this.curator.start();
                ServiceDiscoveryBundle.this.serviceProvider.start();
                ServiceDiscoveryBundle.this.serviceDiscoveryClient.start();
                NodeIdManager nodeIdManager = new NodeIdManager(ServiceDiscoveryBundle.this.curator, serviceName);
                IdGenerator.initialize(nodeIdManager.fixNodeId(), ServiceDiscoveryBundle.this.globalIdConstraints, Collections.emptyMap());
            }

            public void stop() throws Exception {
                ServiceDiscoveryBundle.this.serviceDiscoveryClient.stop();
                ServiceDiscoveryBundle.this.serviceProvider.stop();
                ServiceDiscoveryBundle.this.curator.close();
            }
        });
        environment.jersey().register((Object)new InfoResource(this.serviceDiscoveryClient));
        environment.admin().addTask((Task)new OORTask(this.rotationStatus));
        environment.admin().addTask((Task)new BIRTask(this.rotationStatus));
    }

    protected abstract ServiceDiscoveryConfiguration getRangerConfiguration(T var1);

    protected abstract String getServiceName(T var1);

    protected List<IsolatedHealthMonitor> getHealthMonitors() {
        return Lists.newArrayList();
    }

    protected int getPort(T configuration) {
        Preconditions.checkArgument((-1 != this.serviceDiscoveryConfiguration.getPublishedPort() && 0 != this.serviceDiscoveryConfiguration.getPublishedPort() ? 1 : 0) != 0, (Object)"Looks like publishedPost has not been set and getPort() has not been overridden. This is wrong. \nEither set publishedPort in config or override getPort() to return the port on which the service is running");
        return this.serviceDiscoveryConfiguration.getPublishedPort();
    }

    protected String getHost() throws Exception {
        String host = this.serviceDiscoveryConfiguration.getPublishedHost();
        if (Strings.isNullOrEmpty((String)host) || host.equals("__DEFAULT_SERVICE_HOST")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        return host;
    }

    public void registerHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
    }

    public void registerHealthchecks(List<Healthcheck> healthchecks) {
        this.healthchecks.addAll(healthchecks);
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public ServiceDiscoveryClient getServiceDiscoveryClient() {
        return this.serviceDiscoveryClient;
    }

    public RotationStatus getRotationStatus() {
        return this.rotationStatus;
    }
}

