/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle;

import java.beans.ConstructorProperties;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ServiceDiscoveryConfiguration {
    @NotNull
    @NotEmpty
    private String namespace = "default";
    @NotNull
    @NotEmpty
    private String environment;
    @NotNull
    @NotEmpty
    private String zookeeperConnectionString;
    @Min(value=1000L)
    @Max(value=60000L)
    private int connectionRetryInterval;
    @NotNull
    @NotEmpty
    private String publishedHost = "__DEFAULT_SERVICE_HOST";
    @NotNull
    @Min(value=-1L)
    @Max(value=65535L)
    private int publishedPort = -1;

    public static ServiceDiscoveryConfigurationBuilder builder() {
        return new ServiceDiscoveryConfigurationBuilder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getZookeeperConnectionString() {
        return this.zookeeperConnectionString;
    }

    public int getConnectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public String getPublishedHost() {
        return this.publishedHost;
    }

    public int getPublishedPort() {
        return this.publishedPort;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setZookeeperConnectionString(String zookeeperConnectionString) {
        this.zookeeperConnectionString = zookeeperConnectionString;
    }

    public void setConnectionRetryInterval(int connectionRetryInterval) {
        this.connectionRetryInterval = connectionRetryInterval;
    }

    public void setPublishedHost(String publishedHost) {
        this.publishedHost = publishedHost;
    }

    public void setPublishedPort(int publishedPort) {
        this.publishedPort = publishedPort;
    }

    @ConstructorProperties(value={"namespace", "environment", "zookeeperConnectionString", "connectionRetryInterval", "publishedHost", "publishedPort"})
    public ServiceDiscoveryConfiguration(String namespace, String environment, String zookeeperConnectionString, int connectionRetryInterval, String publishedHost, int publishedPort) {
        this.namespace = namespace;
        this.environment = environment;
        this.zookeeperConnectionString = zookeeperConnectionString;
        this.connectionRetryInterval = connectionRetryInterval;
        this.publishedHost = publishedHost;
        this.publishedPort = publishedPort;
    }

    public ServiceDiscoveryConfiguration() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDiscoveryConfiguration)) {
            return false;
        }
        ServiceDiscoveryConfiguration other = (ServiceDiscoveryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$zookeeperConnectionString = this.getZookeeperConnectionString();
        String other$zookeeperConnectionString = other.getZookeeperConnectionString();
        if (this$zookeeperConnectionString == null ? other$zookeeperConnectionString != null : !this$zookeeperConnectionString.equals(other$zookeeperConnectionString)) {
            return false;
        }
        if (this.getConnectionRetryInterval() != other.getConnectionRetryInterval()) {
            return false;
        }
        String this$publishedHost = this.getPublishedHost();
        String other$publishedHost = other.getPublishedHost();
        if (this$publishedHost == null ? other$publishedHost != null : !this$publishedHost.equals(other$publishedHost)) {
            return false;
        }
        return this.getPublishedPort() == other.getPublishedPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceDiscoveryConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $zookeeperConnectionString = this.getZookeeperConnectionString();
        result = result * 59 + ($zookeeperConnectionString == null ? 43 : $zookeeperConnectionString.hashCode());
        result = result * 59 + this.getConnectionRetryInterval();
        String $publishedHost = this.getPublishedHost();
        result = result * 59 + ($publishedHost == null ? 43 : $publishedHost.hashCode());
        result = result * 59 + this.getPublishedPort();
        return result;
    }

    public String toString() {
        return "ServiceDiscoveryConfiguration(namespace=" + this.getNamespace() + ", environment=" + this.getEnvironment() + ", zookeeperConnectionString=" + this.getZookeeperConnectionString() + ", connectionRetryInterval=" + this.getConnectionRetryInterval() + ", publishedHost=" + this.getPublishedHost() + ", publishedPort=" + this.getPublishedPort() + ")";
    }

    public static class ServiceDiscoveryConfigurationBuilder {
        private String namespace;
        private String environment;
        private String zookeeperConnectionString;
        private int connectionRetryInterval;
        private String publishedHost;
        private int publishedPort;

        ServiceDiscoveryConfigurationBuilder() {
        }

        public ServiceDiscoveryConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder zookeeperConnectionString(String zookeeperConnectionString) {
            this.zookeeperConnectionString = zookeeperConnectionString;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder connectionRetryInterval(int connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder publishedHost(String publishedHost) {
            this.publishedHost = publishedHost;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder publishedPort(int publishedPort) {
            this.publishedPort = publishedPort;
            return this;
        }

        public ServiceDiscoveryConfiguration build() {
            return new ServiceDiscoveryConfiguration(this.namespace, this.environment, this.zookeeperConnectionString, this.connectionRetryInterval, this.publishedHost, this.publishedPort);
        }

        public String toString() {
            return "ServiceDiscoveryConfiguration.ServiceDiscoveryConfigurationBuilder(namespace=" + this.namespace + ", environment=" + this.environment + ", zookeeperConnectionString=" + this.zookeeperConnectionString + ", connectionRetryInterval=" + this.connectionRetryInterval + ", publishedHost=" + this.publishedHost + ", publishedPort=" + this.publishedPort + ")";
        }
    }
}

