/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.cache.caffeine;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Strings;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cache.caffeine.CaffeineFactory;
import io.dropwizard.cache.caffeine.config.CacheConfig;
import io.dropwizard.cache.caffeine.config.CaffeineConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CaffeineBundle<K extends Enum<?>, T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(CaffeineBundle.class);
    private final ConcurrentHashMap<K, Caffeine> caffeineRegistry = new ConcurrentHashMap();
    private final ConcurrentHashMap<K, CacheLoader> loadersRegistry = new ConcurrentHashMap();
    private CaffeineFactory<K> caffeineFactory;
    private CacheConfig defaultCacheConfig;
    private final Class<K> keyEnumType;

    protected CaffeineBundle(Class<K> enumType) {
        this.keyEnumType = enumType;
    }

    public void run(T configuration, Environment environment) throws Exception {
        CaffeineConfig<K> config = this.getConfig(configuration);
        this.defaultCacheConfig = config.getDefaultCacheConfig();
        this.caffeineFactory = new CaffeineFactory(environment.metrics(), config.getMetricsPrefix());
        this.initializeCaffeineRegistry(config.getCache());
    }

    private void initializeCaffeineRegistry(Map<K, CacheConfig> cacheConfigList) {
        if (null == cacheConfigList) {
            return;
        }
        cacheConfigList.forEach((key, value) -> {
            if (value == null || Strings.isNullOrEmpty((String)value.getCaffeineSpec())) {
                return;
            }
            log.info("Initializing Registry Key {}, Spec {}", key, (Object)value.getCaffeineSpec());
            Caffeine caffeine = this.caffeineFactory.fromConfig((CacheConfig)value, (Enum)key);
            log.info("loading {}, {}", key, (Object)caffeine);
            this.caffeineRegistry.put((Enum)key, caffeine);
        });
    }

    public void addLoaders(Map<K, CacheLoader> loaders) {
        this.loadersRegistry.putAll(loaders);
    }

    private K getKeyFromString(String name) {
        for (Enum val : (Enum[])this.keyEnumType.getEnumConstants()) {
            if (!val.name().equals(name)) continue;
            return (K)val;
        }
        log.warn("Invalid Cache name {}", (Object)name);
        return null;
    }

    public Caffeine getCaffeineInstance(K cacheName) {
        return this.caffeineRegistry.computeIfAbsent((Enum)cacheName, cacheNameInt -> this.caffeineFactory.fromConfig(this.defaultCacheConfig, (Enum)cacheNameInt));
    }

    public <C, V> LoadingCache<C, V> loadingCache(K cacheName, CacheLoader<C, V> loader) {
        Caffeine caffeine = this.getCaffeineInstance(cacheName);
        return caffeine.build(loader);
    }

    public <C, V> LoadingCache<C, V> loadingCache(K cacheName) {
        log.info("Trying to load loader for {}", cacheName);
        if (!this.loadersRegistry.containsKey(cacheName)) {
            log.warn("Unbounded loader");
            throw new RuntimeException("No Loaders provided for cacheName : " + ((Enum)cacheName).name());
        }
        CacheLoader loader = this.loadersRegistry.get(cacheName);
        return this.loadingCache(cacheName, loader);
    }

    public abstract CaffeineConfig<K> getConfig(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }
}

