/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.caffeine.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class MetricsStatsCounter
implements StatsCounter {
    private final Meter hitCount;
    private final Meter missCount;
    private final Meter loadSuccessCount;
    private final Meter loadFailureCount;
    private final Timer totalLoadTime;
    private final Meter evictionCount;
    private final Meter evictionWeight;

    public MetricsStatsCounter(MetricRegistry registry, String metricsPrefix) {
        Objects.requireNonNull(metricsPrefix);
        this.hitCount = registry.meter(metricsPrefix + ".hitsCount");
        this.missCount = registry.meter(metricsPrefix + ".missesCount");
        this.totalLoadTime = registry.timer(metricsPrefix + ".loadsTime");
        this.loadSuccessCount = registry.meter(metricsPrefix + ".loadsSuccessCount");
        this.loadFailureCount = registry.meter(metricsPrefix + ".loadsFailureCount");
        this.evictionCount = registry.meter(metricsPrefix + ".evictionCount");
        this.evictionWeight = registry.meter(metricsPrefix + ".evictionWeight");
    }

    public void recordHits(int count) {
        this.hitCount.mark((long)count);
    }

    public void recordMisses(int count) {
        this.missCount.mark((long)count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.loadSuccessCount.mark();
        this.totalLoadTime.update(loadTime, TimeUnit.NANOSECONDS);
    }

    public void recordLoadFailure(long loadTime) {
        this.loadFailureCount.mark();
        this.totalLoadTime.update(loadTime, TimeUnit.NANOSECONDS);
    }

    public void recordEviction() {
        this.recordEviction(1);
    }

    public void recordEviction(int weight) {
        this.evictionCount.mark();
        this.evictionWeight.mark((long)weight);
    }

    public CacheStats snapshot() {
        return new CacheStats(this.hitCount.getCount(), this.missCount.getCount(), this.loadSuccessCount.getCount(), this.loadFailureCount.getCount(), this.totalLoadTime.getCount(), this.evictionCount.getCount(), this.evictionWeight.getCount());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

