/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt.config;

public class JwtAuthBundleConfiguration {
    private int cacheExpiry = 3600;
    private int cacheMaxSize = 1000;
    private int clockSkew = 30;

    public static JwtAuthBundleConfigurationBuilder builder() {
        return new JwtAuthBundleConfigurationBuilder();
    }

    public int getCacheExpiry() {
        return this.cacheExpiry;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public int getClockSkew() {
        return this.clockSkew;
    }

    public void setCacheExpiry(int cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setClockSkew(int clockSkew) {
        this.clockSkew = clockSkew;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAuthBundleConfiguration)) {
            return false;
        }
        JwtAuthBundleConfiguration other = (JwtAuthBundleConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCacheExpiry() != other.getCacheExpiry()) {
            return false;
        }
        if (this.getCacheMaxSize() != other.getCacheMaxSize()) {
            return false;
        }
        return this.getClockSkew() == other.getClockSkew();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAuthBundleConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCacheExpiry();
        result = result * 59 + this.getCacheMaxSize();
        result = result * 59 + this.getClockSkew();
        return result;
    }

    public String toString() {
        return "JwtAuthBundleConfiguration(cacheExpiry=" + this.getCacheExpiry() + ", cacheMaxSize=" + this.getCacheMaxSize() + ", clockSkew=" + this.getClockSkew() + ")";
    }

    public JwtAuthBundleConfiguration(int cacheExpiry, int cacheMaxSize, int clockSkew) {
        this.cacheExpiry = cacheExpiry;
        this.cacheMaxSize = cacheMaxSize;
        this.clockSkew = clockSkew;
    }

    public JwtAuthBundleConfiguration() {
    }

    public static class JwtAuthBundleConfigurationBuilder {
        private int cacheExpiry;
        private int cacheMaxSize;
        private int clockSkew;

        JwtAuthBundleConfigurationBuilder() {
        }

        public JwtAuthBundleConfigurationBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry = cacheExpiry;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder cacheMaxSize(int cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder clockSkew(int clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public JwtAuthBundleConfiguration build() {
            return new JwtAuthBundleConfiguration(this.cacheExpiry, this.cacheMaxSize, this.clockSkew);
        }

        public String toString() {
            return "JwtAuthBundleConfiguration.JwtAuthBundleConfigurationBuilder(cacheExpiry=" + this.cacheExpiry + ", cacheMaxSize=" + this.cacheMaxSize + ", clockSkew=" + this.clockSkew + ")";
        }
    }
}

