/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import io.dropwizard.auth.jwt.annotation.JwtAuthRequired;
import io.dropwizard.auth.jwt.core.JwtUser;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
public class JwtAuthValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public JwtAuthValueFactoryProvider(MultivaluedParameterExtractorProvider multivaluedParameterExtractorProvider, ServiceLocator serviceLocator) {
        super(multivaluedParameterExtractorProvider, serviceLocator, new Parameter.Source[]{Parameter.Source.UNKNOWN});
    }

    protected AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        if (parameter.isAnnotationPresent(JwtAuthRequired.class)) {
            return new AbstractContainerRequestValueFactory<JwtUser>(){

                public JwtUser provide() {
                    Object userObject = this.getContainerRequest().getProperty("user");
                    if (userObject != null && userObject instanceof JwtUser) {
                        return (JwtUser)userObject;
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(JwtAuthValueFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(AuthRequiredInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<JwtAuthRequired>>(){}).in(Singleton.class);
        }
    }

    private static class AuthRequiredInjectionResolver
    extends ParamInjectionResolver<JwtAuthRequired> {
        public AuthRequiredInjectionResolver() {
            super(JwtAuthValueFactoryProvider.class);
        }
    }
}

