/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.actor;

import io.dropwizard.actors.actor.DelayType;
import io.dropwizard.actors.retry.config.NoRetryConfig;
import io.dropwizard.actors.retry.config.RetryConfig;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ActorConfig {
    @NotNull
    @NotEmpty
    private String exchange;
    private boolean delayed = false;
    private DelayType delayType = DelayType.DELAYED;
    @NotNull
    @NotEmpty
    private String prefix = "payments.actors";
    @Min(value=1L)
    @Max(value=100L)
    private int concurrency = 3;
    @Min(value=1L)
    @Max(value=100L)
    private int prefetchCount = 1;
    @NotNull
    @Valid
    private RetryConfig retryConfig = new NoRetryConfig();

    public static ActorConfigBuilder builder() {
        return new ActorConfigBuilder();
    }

    public String getExchange() {
        return this.exchange;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public DelayType getDelayType() {
        return this.delayType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public RetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public void setDelayType(DelayType delayType) {
        this.delayType = delayType;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActorConfig)) {
            return false;
        }
        ActorConfig other = (ActorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$exchange = this.getExchange();
        String other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
            return false;
        }
        if (this.isDelayed() != other.isDelayed()) {
            return false;
        }
        DelayType this$delayType = this.getDelayType();
        DelayType other$delayType = other.getDelayType();
        if (this$delayType == null ? other$delayType != null : !((Object)((Object)this$delayType)).equals((Object)other$delayType)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getPrefetchCount() != other.getPrefetchCount()) {
            return false;
        }
        RetryConfig this$retryConfig = this.getRetryConfig();
        RetryConfig other$retryConfig = other.getRetryConfig();
        return !(this$retryConfig == null ? other$retryConfig != null : !((Object)this$retryConfig).equals(other$retryConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        result = result * 59 + (this.isDelayed() ? 79 : 97);
        DelayType $delayType = this.getDelayType();
        result = result * 59 + ($delayType == null ? 43 : ((Object)((Object)$delayType)).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getPrefetchCount();
        RetryConfig $retryConfig = this.getRetryConfig();
        result = result * 59 + ($retryConfig == null ? 43 : ((Object)$retryConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ActorConfig(exchange=" + this.getExchange() + ", delayed=" + this.isDelayed() + ", delayType=" + (Object)((Object)this.getDelayType()) + ", prefix=" + this.getPrefix() + ", concurrency=" + this.getConcurrency() + ", prefetchCount=" + this.getPrefetchCount() + ", retryConfig=" + this.getRetryConfig() + ")";
    }

    @ConstructorProperties(value={"exchange", "delayed", "delayType", "prefix", "concurrency", "prefetchCount", "retryConfig"})
    public ActorConfig(String exchange, boolean delayed, DelayType delayType, String prefix, int concurrency, int prefetchCount, RetryConfig retryConfig) {
        this.exchange = exchange;
        this.delayed = delayed;
        this.delayType = delayType;
        this.prefix = prefix;
        this.concurrency = concurrency;
        this.prefetchCount = prefetchCount;
        this.retryConfig = retryConfig;
    }

    public ActorConfig() {
    }

    public static class ActorConfigBuilder {
        private String exchange;
        private boolean delayed;
        private DelayType delayType;
        private String prefix;
        private int concurrency;
        private int prefetchCount;
        private RetryConfig retryConfig;

        ActorConfigBuilder() {
        }

        public ActorConfigBuilder exchange(String exchange) {
            this.exchange = exchange;
            return this;
        }

        public ActorConfigBuilder delayed(boolean delayed) {
            this.delayed = delayed;
            return this;
        }

        public ActorConfigBuilder delayType(DelayType delayType) {
            this.delayType = delayType;
            return this;
        }

        public ActorConfigBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ActorConfigBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public ActorConfigBuilder prefetchCount(int prefetchCount) {
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ActorConfigBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        public ActorConfig build() {
            return new ActorConfig(this.exchange, this.delayed, this.delayType, this.prefix, this.concurrency, this.prefetchCount, this.retryConfig);
        }

        public String toString() {
            return "ActorConfig.ActorConfigBuilder(exchange=" + this.exchange + ", delayed=" + this.delayed + ", delayType=" + (Object)((Object)this.delayType) + ", prefix=" + this.prefix + ", concurrency=" + this.concurrency + ", prefetchCount=" + this.prefetchCount + ", retryConfig=" + this.retryConfig + ")";
        }
    }
}

