/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.config;

import io.dropwizard.actors.config.Broker;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class RMQConfig {
    @NotNull
    @NotEmpty
    private List<Broker> brokers;
    @NotEmpty
    @NotNull
    private String userName;
    @NotNull
    private int threadPoolSize;
    @NotEmpty
    @NotNull
    private String password;
    private boolean sslEnabled = false;

    public static RMQConfigBuilder builder() {
        return new RMQConfigBuilder();
    }

    public List<Broker> getBrokers() {
        return this.brokers;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setBrokers(List<Broker> brokers) {
        this.brokers = brokers;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RMQConfig)) {
            return false;
        }
        RMQConfig other = (RMQConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Broker> this$brokers = this.getBrokers();
        List<Broker> other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !((Object)this$brokers).equals(other$brokers)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        return this.isSslEnabled() == other.isSslEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RMQConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Broker> $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : ((Object)$brokers).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        result = result * 59 + this.getThreadPoolSize();
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isSslEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "RMQConfig(brokers=" + this.getBrokers() + ", userName=" + this.getUserName() + ", threadPoolSize=" + this.getThreadPoolSize() + ", password=" + this.getPassword() + ", sslEnabled=" + this.isSslEnabled() + ")";
    }

    @ConstructorProperties(value={"brokers", "userName", "threadPoolSize", "password", "sslEnabled"})
    public RMQConfig(List<Broker> brokers, String userName, int threadPoolSize, String password, boolean sslEnabled) {
        this.brokers = brokers;
        this.userName = userName;
        this.threadPoolSize = threadPoolSize;
        this.password = password;
        this.sslEnabled = sslEnabled;
    }

    public RMQConfig() {
    }

    public static class RMQConfigBuilder {
        private List<Broker> brokers;
        private String userName;
        private int threadPoolSize;
        private String password;
        private boolean sslEnabled;

        RMQConfigBuilder() {
        }

        public RMQConfigBuilder brokers(List<Broker> brokers) {
            this.brokers = brokers;
            return this;
        }

        public RMQConfigBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public RMQConfigBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public RMQConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RMQConfigBuilder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public RMQConfig build() {
            return new RMQConfig(this.brokers, this.userName, this.threadPoolSize, this.password, this.sslEnabled);
        }

        public String toString() {
            return "RMQConfig.RMQConfigBuilder(brokers=" + this.brokers + ", userName=" + this.userName + ", threadPoolSize=" + this.threadPoolSize + ", password=" + this.password + ", sslEnabled=" + this.sslEnabled + ")";
        }
    }
}

