/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.retry;

import io.dropwizard.actors.retry.RetryStrategy;
import io.dropwizard.actors.retry.config.CountLimitedExponentialWaitRetryConfig;
import io.dropwizard.actors.retry.config.CountLimitedFixedWaitRetryConfig;
import io.dropwizard.actors.retry.config.CountLimitedIncrementalWaitRetryConfig;
import io.dropwizard.actors.retry.config.NoRetryConfig;
import io.dropwizard.actors.retry.config.RetryConfig;
import io.dropwizard.actors.retry.config.TimeLimitedExponentialWaitRetryConfig;
import io.dropwizard.actors.retry.config.TimeLimitedFixedWaitRetryConfig;
import io.dropwizard.actors.retry.config.TimeLimitedIncrementalWaitRetryConfig;
import io.dropwizard.actors.retry.impl.CountLimitedExponentialWaitRetryStrategy;
import io.dropwizard.actors.retry.impl.CountLimitedFixedWaitRetryStrategy;
import io.dropwizard.actors.retry.impl.CountLimitedIncrementalWaitRetryStrategy;
import io.dropwizard.actors.retry.impl.NoRetryStrategy;
import io.dropwizard.actors.retry.impl.TimeLimitedExponentialWaitRetryStrategy;
import io.dropwizard.actors.retry.impl.TimeLimitedFixedWaitRetryStrategy;
import io.dropwizard.actors.retry.impl.TimeLimitedIncrementalWaitRetryStrategy;

public class RetryStrategyFactory {
    public RetryStrategy create(RetryConfig config) {
        switch (config.getType()) {
            case NO_RETRY: {
                return new NoRetryStrategy((NoRetryConfig)NoRetryConfig.class.cast(config));
            }
            case TIME_LIMITED_EXPONENTIAL_BACKOFF: {
                return new TimeLimitedExponentialWaitRetryStrategy((TimeLimitedExponentialWaitRetryConfig)TimeLimitedExponentialWaitRetryConfig.class.cast(config));
            }
            case TIME_LIMITED_INCREMENTAL_WAIT: {
                return new TimeLimitedIncrementalWaitRetryStrategy((TimeLimitedIncrementalWaitRetryConfig)TimeLimitedIncrementalWaitRetryConfig.class.cast(config));
            }
            case TIME_LIMITED_FIXED_WAIT: {
                return new TimeLimitedFixedWaitRetryStrategy((TimeLimitedFixedWaitRetryConfig)TimeLimitedFixedWaitRetryConfig.class.cast(config));
            }
            case COUNT_LIMITED_EXPONENTIAL_BACKOFF: {
                return new CountLimitedExponentialWaitRetryStrategy((CountLimitedExponentialWaitRetryConfig)CountLimitedExponentialWaitRetryConfig.class.cast(config));
            }
            case COUNT_LIMITED_INCREMENTAL_WAIT: {
                return new CountLimitedIncrementalWaitRetryStrategy((CountLimitedIncrementalWaitRetryConfig)CountLimitedIncrementalWaitRetryConfig.class.cast(config));
            }
            case COUNT_LIMITED_FIXED_WAIT: {
                return new CountLimitedFixedWaitRetryStrategy((CountLimitedFixedWaitRetryConfig)CountLimitedFixedWaitRetryConfig.class.cast(config));
            }
        }
        return null;
    }
}

