(ns clj.new.io.dominic.wedge
  (:require [clj.new.templates :refer [renderer render-text project-data ->files project-dir]]
            [io.dominic.wedge.impl.dev-tooling :as impl.dev-tooling]))

(defn wedge
  [name]
  (let [render (renderer "io/dominic/wedge")
        data (project-data name)]
    (println "Generating fresh 'clj new' wedge project.")
    (->files data
             ["README" (render "README" data)]
             [".clj-kondo/config.edn" (render "clj-kondo.edn" data)]
             [".gitignore" (render "gitignore" data)]
             ["deps.edn" (render "deps.edn" data)]
             ["app.cljs.edn" (render "app.cljs.edn" data)]
             ["dev.cljs.edn" (render "dev.cljs.edn" data)]
             ["min.cljs.edn" (render "min.cljs.edn" data)]
             ["package.json" (render "package.json" data)]
             ["src/{{nested-dirs}}/web.clj" (render "web.clj" data)]
             ["src/{{nested-dirs}}/app.cljs" (render "app.cljs" data)]
             ["src/{{nested-dirs}}/app/dev.cljs" (render "dev.cljs" data)]
             ["src/{{nested-dirs}}/app/main.cljs" (render "main.cljs" data)]
             ["src/config.edn" (render "config.edn" data)]
             ["src/io/dominic/wedge/system-config.edn" (render "system-config.edn" data)]
             ["dev/log_dev_app.properties" (render-text "app_root_logger={{namespace}}" data)]
             ["dev/user.clj" (render "user.clj" data)]
             ["dev/dev.clj" (render "dev.clj" data)]
             [".dir-locals.el" (impl.dev-tooling/dir-locals ["dev"] false)]
             [".vscode/settings.json" (impl.dev-tooling/calva-settings-json ["dev"] false)]
             ["target/.gitkeep" ""])
    (-> (ProcessBuilder. ["npm" "install"])
        (.directory (java.io.File. (project-dir name)))
        (.inheritIO)
        (.start)
        (.waitFor))))
