(ns io.dominic.wedge.clip-aero
  "Wedge-compatible :system for clip/aero.  Example system_config.edn:
    * {:system io.dominic.wedge.clip-aero}
    * {:system io.dominic.wedge.clip-aero
       :key :clip/system}

  Uses aero to read `config.edn`, and gets the system from it.

  Requires `aero` and `clip` to be on the classpath.

  See [[system-config]] for supported options."
  (:require
    [juxt.clip.core :as clip]
    [io.dominic.wedge.impl.aero :as impl.aero]))

(defn system-config
  "Opts is a map with valid keys:
     :key - the key in config which contains the clip system."
  [{:keys [key]
    :or {key :clip/system}
    :as opts}]
  (get (impl.aero/config opts) key))

(defn start
  [system-conf]
  (vary-meta (clip/start system-conf)
             assoc ::system-conf system-conf))

(defn stop
  [system]
  (let [{::keys [system-conf]} (meta system)]
    (clip/stop system-conf system)))

(defn load-dev
  []
  (load "/io/dominic/wedge/impl/clip_aero_dev"))
