(ns io.dominic.wedge.integrant-aero
  (:require
    [aero.core :as aero]
    [integrant.core :as ig]
    [io.dominic.wedge.impl.aero :as impl.aero]))

(defmethod aero/reader 'ig/ref [_ _ value]
  (ig/ref value))

(defmethod aero/reader 'ig/refset [_ _ value]
  (ig/refset value))

(defn system-config
  [{:keys [key]
    :or {key :ig/system}
    :as opts}]
  (let [system-config (get (impl.aero/config opts) key)]
    (locking clojure.lang.RT/REQUIRE_LOCK
      (ig/load-namespaces system-config))
    (ig/prep system-config)))

(defn start
  [system-conf]
  ;; TODO: :keys support, take opts
  (ig/init system-conf))

(defn stop
  [system]
  (ig/halt! system))

(defn load-dev
  []
  (load "/io/dominic/wedge/impl/integrant_aero_dev"))
