(ns io.dominic.wedge.dev
  (:require
    [clojure.java.io :as io]
    [io.dominic.wedge.impl.dev-system-hooks :as impl.dev-system-hooks]
    [io.dominic.wedge.impl.dev-tooling :as impl.dev-tooling]
    [io.dominic.wedge.system :as wedge.system]))

(wedge.system/load-dev)

(def cljs?
  (try
    (require 'cljs.main)
    true
    (catch java.io.FileNotFoundException _
      false)))

(defn generate-tooling
  ([] (generate-tooling ["dev"]))
  ([clj-aliases]
   (spit ".dir-locals.el"
         (impl.dev-tooling/dir-locals (map name clj-aliases) cljs?))
   (spit (doto ".vscode/settings.json" io/make-parents)
         (impl.dev-tooling/calva-settings-json (map name clj-aliases) cljs?))))

;; TODO: make more doc-friendly using defn to wrap
(def add-dev-system-fixture! #'impl.dev-system-hooks/add-dev-system-fixture!)
(def remove-dev-system-fixture! #'impl.dev-system-hooks/remove-dev-system-fixture!)
