(ns io.dominic.wedge.aero
  "Wedge-compatible :config for aero.  Example system_config.edn:
    * `{:config io.dominic.wedge.aero}`

  Uses aero to read `config.edn`, and uses clojure.core/get to get references
  from it.

  Requires `aero` to be on the classpath.

  If integrant is on the classpath, `#ig/ref` and `#ig/refset` are added as
  extensions to aero which call their respective integrant functions.

  See [[read]] for supported options."
  (:refer-clojure :exclude [get read])
  (:require
    [clojure.java.io :as io]
    [aero.core :as aero]))

(when (try (require 'integrant.core) true
           (catch Exception _ nil))
  (let [igref @(resolve 'integrant.core/ref)
        igrefset @(resolve 'integrant.core/refset)]
    (defmethod aero/reader 'ig/ref [_ _ value]
      (igref value))
    (defmethod aero/reader 'ig/refset [_ _ value]
      (igrefset value))))

(defn read
  "opts will be passed to aero.
     Optional opts:
       ::tag-ns - a list of symbols to be required prior to reading.  Use this to load any namespaces containing Aero tags."
  [{::keys [tag-ns] :as opts}]
  (assert (every? symbol? tag-ns) "Must be symbols in tag-ns")
  (when (seq tag-ns)
    (locking clojure.lang.RT/REQUIRE_LOCK
      (apply require tag-ns)))
  (aero/read-config (io/resource "config.edn") opts))

(def get clojure.core/get)
