(ns io.dominic.wedge.clip
  "Wedge-compatible :system for clip.  Example system_config.edn:
    * {:system io.dominic.wedge.clip}

  Requires `clip` to be on the classpath.

  See [[system-config]] for supported options."
  (:refer-clojure :exclude [key])
  (:require
    [juxt.clip.core :as clip]))

(defn start
  [system-conf _opts]
  (vary-meta (clip/start system-conf)
             assoc ::system-conf system-conf))

(defn stop
  [system]
  (let [{::keys [system-conf]} (meta system)]
    (clip/stop system-conf system)))

(defn load-dev
  []
  (load "/io/dominic/wedge/impl/clip_dev"))

(def key :clip/system)
