(ns io.dominic.wedge.impl.dev-tooling
  "Generate tooling configs for editors."
  (:require
    [clojure.java.io :as io]
    [clojure.string :as string]))

(defn dir-locals
  [clj-aliases cljs?]
  (string/join "\n"
               (filter identity
                       ["((nil"
                        "  (cider-ns-refresh-before-fn . \"io.dominic.wedge.dev/suspend\")"
                        "  (cider-ns-refresh-after-fn  . \"io.dominic.wedge.dev/resume\")"
                        "  (cider-repl-init-code . (\"(dev)\"))"
                        (when (seq clj-aliases)
                          (format "  (cider-clojure-cli-global-options . \"-A:%s\")"
                                  (string/join ":" clj-aliases)))
                        (when cljs?
                          "  (cider-default-cljs-repl . wedge)")
                        (when cljs?
                          "  (cider-cljs-repl-types . ((wedge \"(do (require 'io.dominic.wedge.dev) ((resolve 'io.dominic.wedge.dev/cljs-repl)))\")))))")])))

(defn calva-settings-json
  [clj-aliases cljs?]
  (format
    (slurp
      (io/resource (if cljs?
                     "io/dominic/wedge/dev/cljs_calva_settings.json"
                     "io/dominic/wedge/dev/clj_calva_settings.json")))
    ;; clj aliases
    (string/join "," (map (comp pr-str str) clj-aliases))))
