(ns io.dominic.wedge.clip-aero
  (:require
    [juxt.clip.core :as clip]
    [io.dominic.wedge.impl.aero :as impl.aero]))

(defn system-config
  [{:keys [key]
    :or {key :clip/system}
    :as opts}]
  (get (impl.aero/config opts) key))

(defn start
  [system-conf]
  (vary-meta (clip/start system-conf)
             assoc ::system-conf system-conf))

(defn stop
  [system]
  (let [{::keys [system-conf]} (meta system)]
    (clip/stop system-conf system)))

(defn load-dev
  []
  (load "/io/dominic/wedge/impl/clip_aero_dev"))
