(ns io.dominic.rich-crdt.lww-element-set
  (:require
    [io.dominic.rich-crdt.protocols :as p]))

(declare ->LWWElementSet)

(deftype LWWElementSet [add remove ts ^java.util.Comparator comp]
  p/ICRDTCollection
  (cons [this crdt-entry]
    (if (and
          (contains? ts (first crdt-entry))
          (>= (.compare comp (get ts (first crdt-entry)) (second crdt-entry)) 0))
      this
      (->LWWElementSet (conj add (first crdt-entry))
                       (disj remove (first crdt-entry))
                       (conj ts crdt-entry)
                       comp)))
  (disj [this k-t]
    (let [[k t] k-t]
      (if (and
            (contains? ts k)
            (>= (.compare comp (get ts k) t) 0))
        this
        (->LWWElementSet (disj add k)
                         (conj remove k)
                         (conj ts k-t)
                         comp))))
  (cseq [this] (map #(find ts %) add))
  (dseq [this] (map #(find ts %) remove)))

(defmethod print-method LWWElementSet [lwwes ^java.io.Writer w]
  (.write w "#io.dominic.rich-crdt/lww-element-set[")
  (print-method (.-add lwwes) w)
  (.write w " ") (print-method (.-remove lwwes) w)
  (.write w " ") (print-method (.-ts lwwes) w)
  (.write w "]"))

(defmethod print-dup LWWElementSet [lwwes w] (print-method lwwes w))

(defn lww-element-set
  [& crdt-entrys]
  (->LWWElementSet (into #{} (map first crdt-entrys)) #{} (into {} crdt-entrys) compare))

(defn- read-lww-element-set
  [[add remove ts]]
  (->LWWElementSet add remove ts compare))

(defn lww-element-set-by
  [comp & crdt-entrys]
  (->LWWElementSet (into #{} (map first crdt-entrys)) #{} (into {} crdt-entrys) comp))

(defn with-comparator
  [lww-element-set comp]
  (->LWWElementSet (.-add lww-element-set) (.-remove lww-element-set) (.-ts lww-element-set) comp))

(defn ->clj
  [lww-element-set]
  (.-add lww-element-set))

(deftype ClojureSet [^LWWElementSet crdt update-at s]
  clojure.lang.IPersistentSet
  (disjoin [this key]
    (assert update-at "Must set update-at before making changes to LWWElementSet ClojureMap")
    (let [nv (p/disj crdt [key update-at])]
      (ClojureSet. nv update-at (->clj nv))))
  (get [this key]
    (get s key))
  (contains [this key]
    (contains? s key))
  clojure.lang.IPersistentCollection
  (cons [this o]
    (assert update-at "Must set update-at before making changes to LWWElementSet ClojureMap")
    (let [nv (p/cons crdt [o update-at])]
      (ClojureSet. nv update-at (->clj nv))))
  (empty [this]
    (ClojureSet. (lww-element-set-by (.-comp crdt)) update-at #{}))
  (equiv [this o] (.equiv ^clojure.lang.IPersistentCollection s o))
  (seq [this] (seq s))
  Object
  (equals [this obj] (.equals s obj))
  (hashCode [this] (.hashCode s))
  (toString [this] (.toString s))
  Iterable
  (iterator [this] (.iterator ^Iterable s))
  clojure.lang.Counted
  (count [this] (count s))
  java.util.Collection
  (size [this] (count s))
  java.util.Set
  (isEmpty [this] (.isEmpty ^java.util.Set s))
  (^objects toArray [this ^objects array] (.toArray ^java.util.Collection s array))
  (toArray [this] (.toArray ^java.util.Collection s))
  (containsAll [this coll] (.containsAll ^java.util.Collection s coll))
  clojure.lang.IFn
  (invoke [this v] (s v)))
  
(defn ->clj-set
  ([crdt] (->ClojureSet crdt nil (->clj crdt)))
  ([crdt update-at] (->ClojureSet crdt update-at (->clj crdt))))

(defn update-at
  [^ClojureSet clj-map update-at]
  (->ClojureSet (.-crdt clj-map) update-at (.-s clj-map)))

(defn clj-set->crdt
  [^ClojureSet clj-map]
  (.-crdt clj-map))

(comment
  (-> (->clj-set (lww-element-set))
      (update-at 0)
      (conj "mac@commsor.com")
      (update-at 10)
      (conj "mac@github.com")
      (update-at 20)
      (conj "mac@assembli.io")
      (update-at 5)
      (disj "mac@assembli.io")
      (clj-set->crdt)))
