(ns juxt.yada.ig
  (:require
    [clojure.java.io :as io]
    [integrant.core :as ig]
    [yada.resources.resources-resource :refer [new-resources-resource]]
    [yada.yada :as yada]))

(defmethod ig/init-key ::listener
  [_ opts]
  (assoc (yada/listener (:handler opts)
                        (dissoc opts :handler))
         ::handler (:handler opts)))

(defmethod ig/halt-key! ::listener
  [_ {:keys [close]}]
  (when close (close)))

(defmethod ig/init-key ::redirect
  [_ {:keys [target opts]}]
  (apply yada/redirect (filter some? [target opts])))

(defmethod ig/init-key ::resources
  [_ {:keys [path id]}]
  (cond-> (new-resources-resource path)
    id
    (assoc :id id)))

(defmethod ig/init-key ::classpath-name
  [_ {:keys [name]}]
  (yada/as-resource (io/resource name)))

(defmethod ig/init-key ::webjar
  [_ {:keys [webjar] :as options}]
  (@(requiring-resolve 'yada.resources.webjar-resource/new-webjar-resource)
   webjar
   options))

(defmethod ig/init-key ::webjars-route-pair
  [_ options]
  (@(requiring-resolve 'yada.resources.webjar-resource/webjars-route-pair)
   options))
