/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.IOException;
import net.sourceforge.plantuml.webp.Globals;
import net.sourceforge.plantuml.webp.IDCT;
import net.sourceforge.plantuml.webp.SubBlock;
import net.sourceforge.plantuml.webp.VP8Frame;

public class MacroBlock {
    private int filterLevel;
    private boolean keepDebugInfo = false;
    private int segmentId;
    private int skipCoeff;
    private boolean skipInnerLoopFilter;
    SubBlock[][] uSubBlocks;
    private int uVFilterLevel;
    private int uvMode;
    SubBlock[][] vSubBlocks;
    private int x;
    private int y;
    SubBlock y2SubBlock;
    private int yMode;
    SubBlock[][] ySubBlocks;

    MacroBlock(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.x = n - 1;
        this.y = n2 - 1;
        this.keepDebugInfo = bl;
        this.ySubBlocks = new SubBlock[4][4];
        this.uSubBlocks = new SubBlock[2][2];
        this.vSubBlocks = new SubBlock[2][2];
        SubBlock subBlock = null;
        SubBlock subBlock2 = null;
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 4; ++n3) {
                subBlock2 = null;
                subBlock = null;
                if (n3 > 0) {
                    subBlock2 = this.ySubBlocks[n3 - 1][n4];
                }
                if (n4 > 0) {
                    subBlock = this.ySubBlocks[n3][n4 - 1];
                }
                this.ySubBlocks[n3][n4] = new SubBlock(this, subBlock, subBlock2, SubBlock.PLANE.Y1);
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                subBlock2 = null;
                subBlock = null;
                if (n3 > 0) {
                    subBlock2 = this.uSubBlocks[n3 - 1][n4];
                }
                if (n4 > 0) {
                    subBlock = this.uSubBlocks[n3][n4 - 1];
                }
                this.uSubBlocks[n3][n4] = new SubBlock(this, subBlock, subBlock2, SubBlock.PLANE.U);
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                subBlock2 = null;
                subBlock = null;
                if (n3 > 0) {
                    subBlock2 = this.vSubBlocks[n3 - 1][n4];
                }
                if (n4 > 0) {
                    subBlock = this.vSubBlocks[n3][n4 - 1];
                }
                this.vSubBlocks[n3][n4] = new SubBlock(this, subBlock, subBlock2, SubBlock.PLANE.V);
            }
        }
        this.y2SubBlock = new SubBlock(this, null, null, SubBlock.PLANE.Y2);
    }

    public void decodeMacroBlock(VP8Frame vP8Frame) throws IOException {
        MacroBlock macroBlock = this;
        if (macroBlock.getSkipCoeff() > 0) {
            if (macroBlock.getYMode() != 4) {
                macroBlock.skipInnerLoopFilter = true;
            }
        } else if (macroBlock.getYMode() != 4) {
            this.decodeMacroBlockTokens(vP8Frame, true);
        } else {
            this.decodeMacroBlockTokens(vP8Frame, false);
        }
    }

    private void decodeMacroBlockTokens(VP8Frame vP8Frame, boolean bl) throws IOException {
        this.skipInnerLoopFilter = false;
        if (bl) {
            this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 1, SubBlock.PLANE.Y2, false);
        }
        this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 4, SubBlock.PLANE.Y1, bl);
        this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 2, SubBlock.PLANE.U, false);
        this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 2, SubBlock.PLANE.V, false);
        this.skipInnerLoopFilter = !this.skipInnerLoopFilter;
    }

    private boolean decodePlaneTokens(VP8Frame vP8Frame, int n, SubBlock.PLANE pLANE, boolean bl) throws IOException {
        MacroBlock macroBlock = this;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                SubBlock subBlock = macroBlock.getSubBlock(pLANE, j, i);
                SubBlock subBlock2 = vP8Frame.getLeftSubBlock(subBlock, pLANE);
                SubBlock subBlock3 = vP8Frame.getAboveSubBlock(subBlock, pLANE);
                if (subBlock2.hasNoZeroToken()) {
                    n2 = 1;
                }
                n4 += n2;
                if (subBlock3.hasNoZeroToken()) {
                    n3 = 1;
                }
                subBlock.decodeSubBlock(vP8Frame.getTokenBoolDecoder(), vP8Frame.getCoefProbs(), n4 += n3, SubBlock.planeToType(pLANE, bl), bl);
                bl2 |= subBlock.hasNoZeroToken();
            }
        }
        return bl2;
    }

    public void dequantMacroBlock(VP8Frame vP8Frame) {
        MacroBlock macroBlock = this;
        if (macroBlock.getYMode() != 4) {
            SubBlock subBlock;
            int n;
            int n2;
            SubBlock subBlock2 = macroBlock.getY2SubBlock();
            int n3 = vP8Frame.getSegmentQuants().getSegQuants()[this.getSegmentId()].getY2ac_delta_q();
            int n4 = vP8Frame.getSegmentQuants().getSegQuants()[this.getSegmentId()].getY2dc();
            int[] nArray = new int[16];
            nArray[0] = subBlock2.getTokens()[0] * n4;
            for (n2 = 1; n2 < 16; ++n2) {
                nArray[n2] = subBlock2.getTokens()[n2] * n3;
            }
            subBlock2.setDiff(IDCT.iwalsh4x4(nArray));
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    subBlock = macroBlock.getYSubBlock(n, n2);
                    subBlock.dequantSubBlock(vP8Frame, subBlock2.getDiff()[n][n2]);
                }
            }
            macroBlock.predictY(vP8Frame);
            macroBlock.predictUV(vP8Frame);
            for (n2 = 0; n2 < 2; ++n2) {
                for (n = 0; n < 2; ++n) {
                    subBlock = macroBlock.getUSubBlock(n, n2);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock = macroBlock.getVSubBlock(n2, n);
                    subBlock.dequantSubBlock(vP8Frame, null);
                }
            }
            macroBlock.recon_mb();
        } else {
            SubBlock subBlock;
            int n;
            int n5;
            for (n5 = 0; n5 < 4; ++n5) {
                for (n = 0; n < 4; ++n) {
                    subBlock = macroBlock.getYSubBlock(n, n5);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock.predict(vP8Frame);
                    subBlock.reconstruct();
                }
            }
            macroBlock.predictUV(vP8Frame);
            for (n5 = 0; n5 < 2; ++n5) {
                for (n = 0; n < 2; ++n) {
                    subBlock = macroBlock.getUSubBlock(n, n5);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock.reconstruct();
                }
            }
            for (n5 = 0; n5 < 2; ++n5) {
                for (n = 0; n < 2; ++n) {
                    subBlock = macroBlock.getVSubBlock(n, n5);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock.reconstruct();
                }
            }
        }
    }

    public void drawDebug() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                SubBlock subBlock = this.ySubBlocks[j][0];
                subBlock.drawDebugH();
                subBlock = this.ySubBlocks[0][i];
                subBlock.drawDebugV();
            }
        }
    }

    public SubBlock getBottomSubBlock(int n, SubBlock.PLANE pLANE) {
        if (pLANE == SubBlock.PLANE.Y1) {
            return this.ySubBlocks[n][3];
        }
        if (pLANE == SubBlock.PLANE.U) {
            return this.uSubBlocks[n][1];
        }
        if (pLANE == SubBlock.PLANE.V) {
            return this.vSubBlocks[n][1];
        }
        if (pLANE == SubBlock.PLANE.Y2) {
            return this.y2SubBlock;
        }
        return null;
    }

    public String getDebugString() {
        String string = new String();
        string = string + " YMode: " + Globals.getModeAsString(this.yMode);
        string = string + "\n UVMode: " + Globals.getModeAsString(this.uvMode);
        string = string + "\n SegmentID: " + this.segmentId;
        string = string + "\n Filter Level: " + this.filterLevel;
        string = string + "\n UV Filter Level: " + this.uVFilterLevel;
        string = string + "\n Skip Coeff: " + this.skipCoeff;
        return string;
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public SubBlock getLeftSubBlock(int n, SubBlock.PLANE pLANE) {
        if (pLANE == SubBlock.PLANE.Y1) {
            return this.ySubBlocks[0][n];
        }
        if (pLANE == SubBlock.PLANE.V) {
            return this.vSubBlocks[0][n];
        }
        if (pLANE == SubBlock.PLANE.Y2) {
            return this.y2SubBlock;
        }
        if (pLANE == SubBlock.PLANE.U) {
            return this.uSubBlocks[0][n];
        }
        return null;
    }

    public SubBlock getRightSubBlock(int n, SubBlock.PLANE pLANE) {
        if (pLANE == SubBlock.PLANE.Y1) {
            return this.ySubBlocks[3][n];
        }
        if (pLANE == SubBlock.PLANE.U) {
            return this.uSubBlocks[1][n];
        }
        if (pLANE == SubBlock.PLANE.V) {
            return this.vSubBlocks[1][n];
        }
        if (pLANE == SubBlock.PLANE.Y2) {
            return this.y2SubBlock;
        }
        return null;
    }

    public int getSkipCoeff() {
        return this.skipCoeff;
    }

    public SubBlock getSubBlock(SubBlock.PLANE pLANE, int n, int n2) {
        switch (pLANE) {
            case Y1: {
                return this.getYSubBlock(n, n2);
            }
            case U: {
                return this.getUSubBlock(n, n2);
            }
            case V: {
                return this.getVSubBlock(n, n2);
            }
            case Y2: {
                return this.getY2SubBlock();
            }
        }
        return null;
    }

    public int getSubblockX(SubBlock subBlock) {
        if (subBlock.getPlane() == SubBlock.PLANE.Y1) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.ySubBlocks[j][i] != subBlock) continue;
                    return j;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.PLANE.U) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.uSubBlocks[j][i] != subBlock) continue;
                    return j;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.PLANE.V) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.vSubBlocks[j][i] != subBlock) continue;
                    return j;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.PLANE.Y2) {
            return 0;
        }
        return -100;
    }

    public int getSubblockY(SubBlock subBlock) {
        if (subBlock.getPlane() == SubBlock.PLANE.Y1) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.ySubBlocks[j][i] != subBlock) continue;
                    return i;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.PLANE.U) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.uSubBlocks[j][i] != subBlock) continue;
                    return i;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.PLANE.V) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.vSubBlocks[j][i] != subBlock) continue;
                    return i;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.PLANE.Y2) {
            return 0;
        }
        return -100;
    }

    public SubBlock getUSubBlock(int n, int n2) {
        return this.uSubBlocks[n][n2];
    }

    public int getUVFilterLevel() {
        return this.uVFilterLevel;
    }

    public int getUvMode() {
        return this.uvMode;
    }

    public SubBlock getVSubBlock(int n, int n2) {
        return this.vSubBlocks[n][n2];
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SubBlock getY2SubBlock() {
        return this.y2SubBlock;
    }

    public int getYMode() {
        return this.yMode;
    }

    public SubBlock getYSubBlock(int n, int n2) {
        return this.ySubBlocks[n][n2];
    }

    public boolean isKeepDebugInfo() {
        return this.keepDebugInfo;
    }

    public boolean isSkip_inner_lf() {
        return this.skipInnerLoopFilter;
    }

    public void predictUV(VP8Frame vP8Frame) {
        MacroBlock macroBlock = vP8Frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock macroBlock2 = vP8Frame.getMacroBlock(this.x - 1, this.y);
        switch (this.uvMode) {
            case 0: {
                int n;
                int n2;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                if (this.x > 0) {
                    bl2 = true;
                }
                if (this.y > 0) {
                    bl = true;
                }
                if (bl || bl2) {
                    SubBlock subBlock;
                    SubBlock subBlock2;
                    int n7;
                    if (bl) {
                        for (n7 = 0; n7 < 2; ++n7) {
                            subBlock2 = macroBlock.getUSubBlock(n7, 1);
                            subBlock = macroBlock.getVSubBlock(n7, 1);
                            for (n2 = 0; n2 < 4; ++n2) {
                                n3 += subBlock2.getDest()[n2][3];
                                n4 += subBlock.getDest()[n2][3];
                            }
                        }
                    }
                    if (bl2) {
                        for (n7 = 0; n7 < 2; ++n7) {
                            subBlock2 = macroBlock2.getUSubBlock(1, n7);
                            subBlock = macroBlock2.getVSubBlock(1, n7);
                            for (n2 = 0; n2 < 4; ++n2) {
                                n3 += subBlock2.getDest()[3][n2];
                                n4 += subBlock.getDest()[3][n2];
                            }
                        }
                    }
                    n7 = 2;
                    if (bl) {
                        ++n7;
                    }
                    if (bl2) {
                        ++n7;
                    }
                    n5 = n3 + (1 << n7 - 1) >> n7;
                    n6 = n4 + (1 << n7 - 1) >> n7;
                } else {
                    n5 = 128;
                    n6 = 128;
                }
                int[][] nArray = new int[4][4];
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        nArray[j][i] = n5;
                    }
                }
                int[][] nArray2 = new int[4][4];
                for (n = 0; n < 4; ++n) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        nArray2[n2][n] = n6;
                    }
                }
                for (n = 0; n < 2; ++n) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        SubBlock subBlock = this.uSubBlocks[n2][n];
                        SubBlock subBlock3 = this.vSubBlocks[n2][n];
                        subBlock.setPredict(nArray);
                        subBlock3.setPredict(nArray2);
                    }
                }
                break;
            }
            case 1: {
                int n;
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray2 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray[n] = macroBlock.getUSubBlock(n, 1);
                    subBlockArray2[n] = macroBlock.getVSubBlock(n, 1);
                }
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 2; ++i) {
                        SubBlock subBlock = this.uSubBlocks[n][i];
                        SubBlock subBlock4 = this.vSubBlocks[n][i];
                        int[][] nArray = new int[4][4];
                        int[][] nArray3 = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                nArray[j][k] = subBlockArray[n].getMacroBlockPredict(1)[j][3];
                                nArray3[j][k] = subBlockArray2[n].getMacroBlockPredict(1)[j][3];
                            }
                        }
                        subBlock.setPredict(nArray);
                        subBlock4.setPredict(nArray3);
                    }
                }
                break;
            }
            case 2: {
                int n;
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray3 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray[n] = macroBlock2.getUSubBlock(1, n);
                    subBlockArray3[n] = macroBlock2.getVSubBlock(1, n);
                }
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 2; ++i) {
                        SubBlock subBlock = this.uSubBlocks[i][n];
                        SubBlock subBlock5 = this.vSubBlocks[i][n];
                        int[][] nArray = new int[4][4];
                        int[][] nArray4 = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                nArray[k][j] = subBlockArray[n].getMacroBlockPredict(2)[3][j];
                                nArray4[k][j] = subBlockArray3[n].getMacroBlockPredict(2)[3][j];
                            }
                        }
                        subBlock.setPredict(nArray);
                        subBlock5.setPredict(nArray4);
                    }
                }
                break;
            }
            case 3: {
                int n;
                MacroBlock macroBlock3 = vP8Frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock subBlock = macroBlock3.getUSubBlock(1, 1);
                int n8 = subBlock.getDest()[3][3];
                SubBlock subBlock6 = macroBlock3.getVSubBlock(1, 1);
                int n9 = subBlock6.getDest()[3][3];
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray4 = new SubBlock[2];
                SubBlock[] subBlockArray5 = new SubBlock[2];
                SubBlock[] subBlockArray6 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray[n] = macroBlock.getUSubBlock(n, 1);
                    subBlockArray4[n] = macroBlock2.getUSubBlock(1, n);
                    subBlockArray5[n] = macroBlock.getVSubBlock(n, 1);
                    subBlockArray6[n] = macroBlock2.getVSubBlock(1, n);
                }
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                int n10 = subBlockArray4[n].getDest()[3][i] + subBlockArray[j].getDest()[k][3] - n8;
                                n10 = Globals.clamp(n10, 255);
                                this.uSubBlocks[j][n].setPixel(k, i, n10);
                                int n11 = subBlockArray6[n].getDest()[3][i] + subBlockArray5[j].getDest()[k][3] - n9;
                                n11 = Globals.clamp(n11, 255);
                                this.vSubBlocks[j][n].setPixel(k, i, n11);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                System.out.println("TODO predict_mb_uv: " + this.yMode);
                System.exit(0);
            }
        }
    }

    public void predictY(VP8Frame vP8Frame) {
        MacroBlock macroBlock = vP8Frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock macroBlock2 = vP8Frame.getMacroBlock(this.x - 1, this.y);
        switch (this.yMode) {
            case 0: {
                int n;
                int n2;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                int n4 = 0;
                if (this.x > 0) {
                    bl2 = true;
                }
                if (this.y > 0) {
                    bl = true;
                }
                if (bl || bl2) {
                    SubBlock subBlock;
                    int n5;
                    if (bl) {
                        for (n5 = 0; n5 < 4; ++n5) {
                            subBlock = macroBlock.getYSubBlock(n5, 3);
                            for (n2 = 0; n2 < 4; ++n2) {
                                n3 += subBlock.getDest()[n2][3];
                            }
                        }
                    }
                    if (bl2) {
                        for (n5 = 0; n5 < 4; ++n5) {
                            subBlock = macroBlock2.getYSubBlock(3, n5);
                            for (n2 = 0; n2 < 4; ++n2) {
                                n3 += subBlock.getDest()[3][n2];
                            }
                        }
                    }
                    n5 = 3;
                    if (bl) {
                        ++n5;
                    }
                    if (bl2) {
                        ++n5;
                    }
                    n4 = n3 + (1 << n5 - 1) >> n5;
                } else {
                    n4 = 128;
                }
                int[][] nArray = new int[4][4];
                for (n = 0; n < 4; ++n) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        nArray[n2][n] = n4;
                    }
                }
                for (n = 0; n < 4; ++n) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        SubBlock subBlock = this.ySubBlocks[n2][n];
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 1: {
                int n;
                SubBlock[] subBlockArray = new SubBlock[4];
                for (n = 0; n < 4; ++n) {
                    subBlockArray[n] = macroBlock.getYSubBlock(n, 3);
                }
                for (n = 0; n < 4; ++n) {
                    for (int i = 0; i < 4; ++i) {
                        SubBlock subBlock = this.ySubBlocks[i][n];
                        int[][] nArray = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                nArray[k][j] = subBlockArray[i].getPredict(2, false)[k][3];
                            }
                        }
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 2: {
                int n;
                int n6;
                SubBlock[] subBlockArray = new SubBlock[4];
                for (n6 = 0; n6 < 4; ++n6) {
                    subBlockArray[n6] = macroBlock2.getYSubBlock(3, n6);
                }
                for (n6 = 0; n6 < 4; ++n6) {
                    for (n = 0; n < 4; ++n) {
                        SubBlock subBlock = this.ySubBlocks[n][n6];
                        int[][] nArray = new int[4][4];
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                nArray[j][i] = subBlockArray[n6].getPredict(0, true)[3][i];
                            }
                        }
                        subBlock.setPredict(nArray);
                    }
                }
                SubBlock[] subBlockArray2 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray2[n] = macroBlock2.getYSubBlock(1, n);
                }
                break;
            }
            case 3: {
                int n;
                MacroBlock macroBlock3 = vP8Frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock subBlock = macroBlock3.getYSubBlock(3, 3);
                int n7 = subBlock.getDest()[3][3];
                SubBlock[] subBlockArray = new SubBlock[4];
                SubBlock[] subBlockArray3 = new SubBlock[4];
                for (n = 0; n < 4; ++n) {
                    subBlockArray[n] = macroBlock.getYSubBlock(n, 3);
                }
                for (n = 0; n < 4; ++n) {
                    subBlockArray3[n] = macroBlock2.getYSubBlock(3, n);
                }
                int[][] nArray = new int[4][4];
                for (n = 0; n < 4; ++n) {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                int n8 = subBlockArray3[n].getDest()[3][i] + subBlockArray[j].getDest()[k][3] - n7;
                                this.ySubBlocks[j][n].setPixel(k, i, Globals.clamp(n8, 255));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                System.out.println("TODO predict_mb_y: " + this.yMode);
                System.exit(0);
            }
        }
    }

    public void recon_mb() {
        SubBlock subBlock;
        int n;
        int n2;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                subBlock = this.ySubBlocks[n][n2];
                subBlock.reconstruct();
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < 2; ++n) {
                subBlock = this.uSubBlocks[n][n2];
                subBlock.reconstruct();
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < 2; ++n) {
                subBlock = this.vSubBlocks[n][n2];
                subBlock.reconstruct();
            }
        }
    }

    public void setFilterLevel(int n) {
        this.filterLevel = n;
    }

    public void setSegmentId(int n) {
        this.segmentId = n;
    }

    public void setSkipCoeff(int n) {
        this.skipCoeff = n;
    }

    public void setUVFilterLevel(int n) {
        this.uVFilterLevel = n;
    }

    public void setUvMode(int n) {
        this.uvMode = n;
    }

    public void setYMode(int n) {
        this.yMode = n;
    }

    public String toString() {
        return "x: " + this.x + "y: " + this.y;
    }

    public int getSegmentId() {
        return this.segmentId;
    }
}

