/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.webp.Globals;

public class BoolDecoder {
    int bit_count;
    ImageInputStream data;
    private long offset;
    private int range;
    private int value;

    BoolDecoder(ImageInputStream imageInputStream, long l) throws IOException {
        this.data = imageInputStream;
        this.offset = l;
        this.initBoolDecoder();
    }

    private void initBoolDecoder() throws IOException {
        this.value = 0;
        this.data.seek(this.offset);
        this.value = this.data.readUnsignedByte() << 8;
        ++this.offset;
        this.range = 255;
        this.bit_count = 0;
    }

    public int readBit() throws IOException {
        return this.readBool(128);
    }

    public int readBool(int n) throws IOException {
        int n2 = 0;
        int n3 = this.range;
        int n4 = this.value;
        int n5 = 1 + ((n3 - 1) * n >> 8);
        int n6 = n5 << 8;
        n3 = n5;
        if (n4 >= n6) {
            n3 = this.range - n5;
            n4 -= n6;
            n2 = 1;
        }
        int n7 = this.bit_count;
        int n8 = Globals.vp8dxBitreaderNorm[n3];
        n3 <<= n8;
        n4 <<= n8;
        if ((n7 -= n8) <= 0) {
            n4 |= this.data.readUnsignedByte() << -n7;
            ++this.offset;
            n7 += 8;
        }
        this.bit_count = n7;
        this.value = n4;
        this.range = n3;
        return n2;
    }

    public int readLiteral(int n) throws IOException {
        int n2 = 0;
        while (n-- > 0) {
            n2 = (n2 << 1) + this.readBool(128);
        }
        return n2;
    }

    int readTree(int[] nArray, int[] nArray2) throws IOException {
        int n = 0;
        while ((n = nArray[n + this.readBool(nArray2[n >> 1])]) > 0) {
        }
        return -n;
    }

    int readTreeSkip(int[] nArray, int[] nArray2, int n) throws IOException {
        int n2 = n * 2;
        while ((n2 = nArray[n2 + this.readBool(nArray2[n2 >> 1])]) > 0) {
        }
        return -n2;
    }

    public void seek() throws IOException {
        this.data.seek(this.offset);
    }

    public String toString() {
        return "bc: " + this.value;
    }
}

