/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.DiagramType;

public class StartUtils {
    public static final Pattern2 patternFilename = MyPattern.cmpile("^[@\\\\]start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");
    public static final String PAUSE_PATTERN = "(?i)((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause";
    public static final String START_PATTERN = "(?i)((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start";
    private static final Pattern2 append = MyPattern.cmpile("^\\W*[@\\\\]append");

    public static String beforeStartUml(CharSequence2 charSequence2) {
        boolean bl = false;
        for (int i = 0; i < charSequence2.length(); ++i) {
            CharSequence2 charSequence22 = charSequence2.subSequence(i, charSequence2.length());
            if (StartUtils.startsWithSymbolAnd("start", charSequence22)) {
                return charSequence2.subSequence(0, i).toString();
            }
            String string = charSequence2.subSequence(i, i + 1).toString();
            if (bl) {
                if (!string.equals(">")) continue;
                bl = false;
                continue;
            }
            if (string.equals("<")) {
                bl = true;
                continue;
            }
            if (!string.matches("[\\w~]")) continue;
            return null;
        }
        return null;
    }

    public static boolean isArobaseStartDiagram(CharSequence charSequence) {
        String string = StringUtils.trinNoTrace(charSequence);
        return DiagramType.getTypeFromArobaseStart(string) != DiagramType.UNKNOWN;
    }

    public static boolean startsWithSymbolAnd(String string, CharSequence2 charSequence2) {
        return charSequence2.startsWith("@" + string) || charSequence2.startsWith("\\" + string);
    }

    public static boolean startsWithSymbolAnd(String string, String string2) {
        return string2.startsWith("@" + string) || string2.startsWith("\\" + string);
    }

    public static boolean isArobaseEndDiagram(CharSequence charSequence) {
        String string = StringUtils.trinNoTrace(charSequence);
        return StartUtils.startsWithSymbolAnd("end", string);
    }

    public static boolean isArobasePauseDiagram(CharSequence charSequence) {
        String string = StringUtils.trinNoTrace(charSequence);
        return StartUtils.startsWithSymbolAnd("pause", string);
    }

    public static boolean isArobaseUnpauseDiagram(CharSequence charSequence) {
        String string = StringUtils.trinNoTrace(charSequence);
        return StartUtils.startsWithSymbolAnd("unpause", string);
    }

    public static CharSequence2 getPossibleAppend(CharSequence2 charSequence2) {
        Matcher2 matcher2 = append.matcher(charSequence2);
        if (matcher2.find()) {
            return charSequence2.subSequence(matcher2.group(0).length(), charSequence2.length()).trin();
        }
        return null;
    }
}

