/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UShape;

public class URectangle
extends AbstractShadowable
implements Scalable {
    private final double width;
    private final double height;
    private final double rx;
    private final double ry;
    private final String comment;

    public UShape getScaled(double d) {
        if (d == 1.0) {
            return this;
        }
        URectangle uRectangle = new URectangle(this.width * d, this.height * d, this.rx * d, this.ry * d, this.comment);
        ((AbstractShadowable)uRectangle).setDeltaShadow(this.getDeltaShadow());
        return uRectangle;
    }

    public URectangle(double d, double d2) {
        this(d, d2, 0.0, 0.0, null);
    }

    public URectangle(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, null);
    }

    public URectangle(double d, double d2, double d3, double d4, String string) {
        if (d == 0.0) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
        this.width = d;
        this.height = d2;
        this.rx = d3;
        this.ry = d4;
    }

    public URectangle(Dimension2D dimension2D) {
        this(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public String toString() {
        return "width=" + this.width + " height=" + this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getRx() {
        return this.rx;
    }

    public double getRy() {
        return this.ry;
    }

    public URectangle clip(UClip uClip) {
        return this;
    }

    public MinMax getMinMax() {
        return MinMax.fromMax(this.width, this.height);
    }

    public final String getComment() {
        return this.comment;
    }
}

