/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPath
extends AbstractShadowable
implements Iterable<USegment> {
    private final String comment;
    private final List<USegment> segments = new ArrayList<USegment>();
    private MinMax minmax = MinMax.getEmpty(false);
    private boolean isOpenIconic;

    public UPath(String string) {
        this.comment = string;
    }

    public UPath() {
        this(null);
    }

    public void add(double[] dArray, USegmentType uSegmentType) {
        this.addInternal(new USegment(dArray, uSegmentType));
    }

    private void addInternal(USegment uSegment) {
        this.segments.add(uSegment);
        double[] dArray = uSegment.getCoord();
        if (uSegment.getSegmentType() == USegmentType.SEG_ARCTO) {
            this.minmax = this.minmax.addPoint(dArray[5], dArray[6]);
        } else {
            for (int i = 0; i < dArray.length; i += 2) {
                this.minmax = this.minmax.addPoint(dArray[i], dArray[i + 1]);
            }
        }
    }

    public UPath translate(double d, double d2) {
        UPath uPath = new UPath(this.comment);
        for (USegment uSegment : this.segments) {
            uPath.addInternal(uSegment.translate(d, d2));
        }
        return uPath;
    }

    public UPath rotate(double d) {
        UPath uPath = new UPath(this.comment);
        for (USegment uSegment : this.segments) {
            uPath.addInternal(uSegment.rotate(d));
        }
        return uPath;
    }

    public void moveTo(Point2D point2D) {
        this.moveTo(point2D.getX(), point2D.getY());
    }

    public void lineTo(Point2D point2D) {
        this.lineTo(point2D.getX(), point2D.getY());
    }

    public void moveTo(double d, double d2) {
        this.add(new double[]{d, d2}, USegmentType.SEG_MOVETO);
    }

    public void lineTo(double d, double d2) {
        this.add(new double[]{d, d2}, USegmentType.SEG_LINETO);
    }

    public void cubicTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.add(new double[]{d, d2, d3, d4, d5, d6}, USegmentType.SEG_CUBICTO);
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        this.add(new double[]{d, d2, d, d2, d3, d4}, USegmentType.SEG_CUBICTO);
    }

    public void quadTo(Point2D point2D, Point2D point2D2) {
        this.quadTo(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void arcTo(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.add(new double[]{d, d2, d3, d4, d5, d6, d7}, USegmentType.SEG_ARCTO);
    }

    public void arcTo(Point2D point2D, double d, double d2, double d3) {
        this.add(new double[]{d, d, 0.0, d2, d3, point2D.getX(), point2D.getY()}, USegmentType.SEG_ARCTO);
    }

    public void closePath() {
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public String toString() {
        return this.segments.toString();
    }

    @Override
    public Iterator<USegment> iterator() {
        return this.segments.iterator();
    }

    public boolean isOpenIconic() {
        return this.isOpenIconic;
    }

    public void setOpenIconic(boolean bl) {
        this.isOpenIconic = bl;
    }

    public final String getComment() {
        return this.comment;
    }
}

