/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUGraphic<O>
extends AbstractCommonUGraphic {
    private final O graphic;
    private final Map<Class<? extends UShape>, UDriver<O>> drivers = new HashMap<Class<? extends UShape>, UDriver<O>>();

    public AbstractUGraphic(ColorMapper colorMapper, O o) {
        super(colorMapper);
        this.graphic = o;
    }

    protected AbstractUGraphic(AbstractUGraphic<O> abstractUGraphic) {
        super(abstractUGraphic);
        this.graphic = abstractUGraphic.graphic;
    }

    protected final O getGraphicObject() {
        return this.graphic;
    }

    protected boolean manageHiddenAutomatically() {
        return true;
    }

    protected final void registerDriver(Class<? extends UShape> clazz, UDriver<O> uDriver) {
        this.drivers.put(clazz, uDriver);
    }

    @Override
    public final void draw(UShape uShape) {
        if (uShape instanceof UEmpty) {
            return;
        }
        if (uShape instanceof UComment) {
            this.drawComment((UComment)uShape);
            return;
        }
        UDriver<O> uDriver = this.drivers.get(uShape.getClass());
        if (uDriver == null) {
            throw new UnsupportedOperationException(uShape.getClass().toString() + " " + this.getClass());
        }
        if (this.getParam().isHidden() && this.manageHiddenAutomatically()) {
            return;
        }
        this.beforeDraw();
        if (uShape instanceof Scalable) {
            double d = this.getParam().getScale();
            uShape = ((Scalable)((Object)uShape)).getScaled(d);
            uDriver.draw(uShape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.graphic);
        } else {
            uDriver.draw(uShape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.graphic);
        }
        this.afterDraw();
    }

    protected void drawComment(UComment uComment) {
    }

    protected void beforeDraw() {
    }

    protected void afterDraw() {
    }
}

